/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExChangePostState;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.Objects;

public final class RequestCancelPostAttachment
extends L2GameClientPacket {
    private static final String _C__D0_6F_REQUESTCANCELPOSTATTACHMENT = "[C] D0:6F RequestCancelPostAttachment";
    private int _msgId;

    @Override
    protected void readImpl() {
        this._msgId = this.readD();
    }

    @Override
    public void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || !Configuration.general().allowMail() || !Configuration.general().allowAttachments()) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("cancelpost")) {
            return;
        }
        Message msg = MailManager.getInstance().getMessage(this._msgId);
        if (msg == null) {
            return;
        }
        if (msg.getSenderId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to cancel not own post!");
            return;
        }
        if (!activeChar.isInsideZone(ZoneId.PEACE)) {
            activeChar.sendPacket(SystemMessageId.CANT_CANCEL_NOT_IN_PEACE_ZONE);
            return;
        }
        if (activeChar.getActiveTradeList() != null) {
            activeChar.sendPacket(SystemMessageId.CANT_CANCEL_DURING_EXCHANGE);
            return;
        }
        if (activeChar.isEnchanting()) {
            activeChar.sendPacket(SystemMessageId.CANT_CANCEL_DURING_ENCHANT);
            return;
        }
        if (activeChar.getPrivateStoreType() != PrivateStoreType.NONE) {
            activeChar.sendPacket(SystemMessageId.CANT_CANCEL_PRIVATE_STORE);
            return;
        }
        if (!msg.hasAttachments()) {
            activeChar.sendPacket(SystemMessageId.YOU_CANT_CANCEL_RECEIVED_MAIL);
            return;
        }
        Mail attachments = msg.getAttachments();
        if (attachments == null || attachments.getSize() == 0) {
            activeChar.sendPacket(SystemMessageId.YOU_CANT_CANCEL_RECEIVED_MAIL);
            return;
        }
        int weight = 0;
        int slots = 0;
        for (L2ItemInstance item : attachments.getItems()) {
            if (item == null) continue;
            if (item.getOwnerId() != activeChar.getObjectId()) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get not own item from cancelled attachment!");
                return;
            }
            if (item.getItemLocation() != ItemLocation.MAIL) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get items not from mail !");
                return;
            }
            if (item.getLocationSlot() != msg.getId()) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get items from different attachment!");
                return;
            }
            weight = (int)((long)weight + item.getCount() * (long)item.getItem().getWeight());
            if (!item.isStackable()) {
                slots = (int)((long)slots + item.getCount());
                continue;
            }
            if (activeChar.getInventory().getItemByItemId(item.getId()) != null) continue;
            ++slots;
        }
        if (!activeChar.getInventory().validateCapacity(slots)) {
            activeChar.sendPacket(SystemMessageId.CANT_CANCEL_INVENTORY_FULL);
            return;
        }
        if (!activeChar.getInventory().validateWeight(weight)) {
            activeChar.sendPacket(SystemMessageId.CANT_CANCEL_INVENTORY_FULL);
            return;
        }
        InventoryUpdate playerIU = Configuration.general().forceInventoryUpdate() ? null : new InventoryUpdate();
        for (L2ItemInstance item : attachments.getItems()) {
            if (item == null) continue;
            long count = item.getCount();
            L2ItemInstance newItem = attachments.transferItem(((ItemContainer)attachments).getName(), item.getObjectId(), count, activeChar.getInventory(), activeChar, null);
            if (newItem == null) {
                return;
            }
            if (playerIU != null) {
                if (newItem.getCount() > count) {
                    playerIU.addModifiedItem(newItem);
                } else {
                    playerIU.addNewItem(newItem);
                }
            }
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_ACQUIRED_S2_S1);
            sm.addItemName(item.getId());
            sm.addLong(count);
            activeChar.sendPacket(sm);
        }
        msg.removeAttachments();
        activeChar.sendPacket(Objects.requireNonNullElseGet(playerIU, () -> new ItemList(activeChar, false)));
        StatusUpdate su = new StatusUpdate(activeChar);
        su.addAttribute(14, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
        L2PcInstance receiver = L2World.getInstance().getPlayer(msg.getReceiverId());
        if (receiver != null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANCELLED_MAIL);
            sm.addCharName(activeChar);
            receiver.sendPacket(sm);
            receiver.sendPacket(new ExChangePostState(true, this._msgId, 0));
        }
        MailManager.getInstance().deleteMessageInDb(this._msgId);
        activeChar.sendPacket(new ExChangePostState(false, this._msgId, 0));
        activeChar.sendPacket(SystemMessageId.MAIL_SUCCESSFULLY_CANCELLED);
    }

    @Override
    public String getType() {
        return _C__D0_6F_REQUESTCANCELPOSTATTACHMENT;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

