/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExDuelAskStart;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestDuelStart
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDuelStart.class);
    private static final String _C__D0_1B_REQUESTDUELSTART = "[C] D0:1B RequestDuelStart";
    private String _player;
    private int _partyDuel;

    @Override
    protected void readImpl() {
        this._player = this.readS();
        this._partyDuel = this.readD();
    }

    @Override
    protected void runImpl() {
        boolean isPartyDuel;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        L2PcInstance targetChar = L2World.getInstance().getPlayer(this._player);
        boolean bl = isPartyDuel = this._partyDuel == 1;
        if (activeChar == null || targetChar == null) {
            return;
        }
        if (activeChar == targetChar) {
            if (isPartyDuel) {
                activeChar.sendPacket(SystemMessageId.THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL);
            }
            return;
        }
        if (!activeChar.isInsideRadius(targetChar, 250, false, false)) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_RECEIVE_A_DUEL_CHALLENGE_BECAUSE_C1_IS_TOO_FAR_AWAY);
            msg.addString(targetChar.getName());
            activeChar.sendPacket(msg);
            return;
        }
        if (!DuelManager.canDuel(activeChar, activeChar, isPartyDuel)) {
            return;
        }
        if (!DuelManager.canDuel(activeChar, targetChar, isPartyDuel)) {
            return;
        }
        if (isPartyDuel) {
            if (!activeChar.isInParty() || !activeChar.getParty().isLeader(activeChar) || !targetChar.isInParty() || activeChar.getParty().containsPlayer(targetChar)) {
                activeChar.sendPacket(SystemMessageId.YOU_ARE_UNABLE_TO_REQUEST_A_DUEL_AT_THIS_TIME);
                return;
            }
            for (L2PcInstance l2PcInstance : activeChar.getParty().getMembers()) {
                if (DuelManager.canDuel(activeChar, l2PcInstance, isPartyDuel)) continue;
                return;
            }
            L2PcInstance partyLeader = targetChar.getParty().getLeader();
            for (L2PcInstance temp : targetChar.getParty().getMembers()) {
                if (DuelManager.canDuel(activeChar, temp, isPartyDuel)) continue;
                return;
            }
            if (partyLeader != null) {
                if (!partyLeader.isProcessingRequest()) {
                    activeChar.onTransactionRequest(partyLeader);
                    partyLeader.sendPacket(new ExDuelAskStart(activeChar.getName(), this._partyDuel));
                    if (Configuration.general().debug()) {
                        LOG.debug("{} requested a duel with {}", (Object)activeChar.getName(), (Object)partyLeader.getName());
                    }
                    SystemMessage systemMessage = SystemMessage.getSystemMessage(SystemMessageId.C1_PARTY_HAS_BEEN_CHALLENGED_TO_A_DUEL);
                    systemMessage.addString(partyLeader.getName());
                    activeChar.sendPacket(systemMessage);
                    SystemMessage systemMessage2 = SystemMessage.getSystemMessage(SystemMessageId.C1_PARTY_HAS_CHALLENGED_YOUR_PARTY_TO_A_DUEL);
                    systemMessage2.addString(activeChar.getName());
                    targetChar.sendPacket(systemMessage2);
                } else {
                    SystemMessage systemMessage = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
                    systemMessage.addString(partyLeader.getName());
                    activeChar.sendPacket(systemMessage);
                }
            }
        } else if (!targetChar.isProcessingRequest()) {
            activeChar.onTransactionRequest(targetChar);
            targetChar.sendPacket(new ExDuelAskStart(activeChar.getName(), this._partyDuel));
            if (Configuration.general().debug()) {
                LOG.debug("{} requested a duel with {}", (Object)activeChar.getName(), (Object)targetChar.getName());
            }
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_BEEN_CHALLENGED_TO_A_DUEL);
            msg.addString(targetChar.getName());
            activeChar.sendPacket(msg);
            msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_CHALLENGED_YOU_TO_A_DUEL);
            msg.addString(activeChar.getName());
            targetChar.sendPacket(msg);
        } else {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            msg.addString(targetChar.getName());
            activeChar.sendPacket(msg);
        }
    }

    @Override
    public String getType() {
        return _C__D0_1B_REQUESTDUELSTART;
    }
}

