/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestExMagicSkillUseGround
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExMagicSkillUseGround.class);
    private static final String _C__D0_44_REQUESTEXMAGICSKILLUSEGROUND = "[C] D0:44 RequestExMagicSkillUseGround";
    private int _x;
    private int _y;
    private int _z;
    private int _skillId;
    private boolean _ctrlPressed;
    private boolean _shiftPressed;

    @Override
    protected void readImpl() {
        this._x = this.readD();
        this._y = this.readD();
        this._z = this.readD();
        this._skillId = this.readD();
        this._ctrlPressed = this.readD() != 0;
        this._shiftPressed = this.readC() != 0;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int level = activeChar.getSkillLevel(this._skillId);
        if (level <= 0) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._skillId, level);
        if (skill != null) {
            activeChar.setCurrentSkillWorldPosition(new Location(this._x, this._y, this._z));
            activeChar.setHeading(Util.calculateHeadingFrom(activeChar.getX(), activeChar.getY(), this._x, this._y));
            Broadcast.toKnownPlayers(activeChar, new ValidateLocation(activeChar));
            activeChar.useMagic(skill, this._ctrlPressed, this._shiftPressed);
        } else {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            LOG.warn("No skill found with id {} and level {} !!", (Object)this._skillId, (Object)level);
        }
    }

    @Override
    public String getType() {
        return _C__D0_44_REQUESTEXMAGICSKILLUSEGROUND;
    }
}

