/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendAddRequest;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestFriendInvite
extends L2GameClientPacket {
    private static final String _C__77_REQUESTFRIENDINVITE = "[C] 77 RequestFriendInvite";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance friend = L2World.getInstance().getPlayer(this._name);
        if (friend == null || !friend.isOnline() || friend.isInvisible()) {
            activeChar.sendPacket(SystemMessageId.THE_USER_YOU_REQUESTED_IS_NOT_IN_GAME);
            return;
        }
        if (friend == activeChar) {
            activeChar.sendPacket(SystemMessageId.YOU_CANNOT_ADD_YOURSELF_TO_OWN_FRIEND_LIST);
            return;
        }
        if (activeChar.getFriends().size() >= Configuration.character().getFriendListLimit()) {
            activeChar.sendPacket(SystemMessageId.YOU_CAN_ONLY_ENTER_UP_128_NAMES_IN_YOUR_FRIENDS_LIST);
            return;
        }
        if (friend.getFriends().size() >= Configuration.character().getFriendListLimit()) {
            activeChar.sendPacket(SystemMessageId.THE_FRIENDS_LIST_OF_THE_PERSON_YOU_ARE_TRYING_TO_ADD_IS_FULL_SO_REGISTRATION_IS_NOT_POSSIBLE);
            return;
        }
        if (activeChar.isInOlympiadMode() || friend.isInOlympiadMode()) {
            activeChar.sendPacket(SystemMessageId.A_USER_CURRENTLY_PARTICIPATING_IN_THE_OLYMPIAD_CANNOT_SEND_PARTY_AND_FRIEND_INVITATIONS);
            return;
        }
        if (BlockList.isBlocked(friend, activeChar)) {
            activeChar.sendMessage("You are in target's block list.");
            return;
        }
        if (BlockList.isBlocked(activeChar, friend)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.BLOCKED_C1);
            sm.addCharName(friend);
            activeChar.sendPacket(sm);
            return;
        }
        if (activeChar.isFriend(friend.getObjectId())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_IN_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        if (friend.isProcessingRequest()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        activeChar.onTransactionRequest(friend);
        friend.sendPacket(new FriendAddRequest(activeChar.getName()));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_REQUESTED_C1_TO_BE_FRIEND);
        sm.addString(this._name);
        activeChar.sendPacket(sm);
    }

    @Override
    public String getType() {
        return _C__77_REQUESTFRIENDINVITE;
    }
}

