/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExPartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.PartyMatchDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPartyMatchList
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPartyMatchList.class);
    private static final String _C__80_REQUESTPARTYMATCHLIST = "[C] 80 RequestPartyMatchList";
    private int _roomid;
    private int _membersmax;
    private int _lvlmin;
    private int _lvlmax;
    private int _loot;
    private String _roomtitle;

    @Override
    protected void readImpl() {
        this._roomid = this.readD();
        this._membersmax = this.readD();
        this._lvlmin = this.readD();
        this._lvlmax = this.readD();
        this._loot = this.readD();
        this._roomtitle = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance _activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (_activeChar == null) {
            return;
        }
        if (this._roomid > 0) {
            PartyMatchRoom _room = PartyMatchRoomList.getInstance().getRoom(this._roomid);
            if (_room != null) {
                LOG.info("PartyMatchRoom #{} changed by {}", (Object)_room.getId(), (Object)_activeChar.getName());
                _room.setMaxMembers(this._membersmax);
                _room.setMinLvl(this._lvlmin);
                _room.setMaxLvl(this._lvlmax);
                _room.setLootType(this._loot);
                _room.setTitle(this._roomtitle);
                for (L2PcInstance _member : _room.getPartyMembers()) {
                    if (_member == null) continue;
                    _member.sendPacket(new PartyMatchDetail(_activeChar, _room));
                    _member.sendPacket(SystemMessageId.PARTY_ROOM_REVISED);
                }
            }
        } else {
            int _maxid = PartyMatchRoomList.getInstance().getMaxId();
            PartyMatchRoom _room = new PartyMatchRoom(_maxid, this._roomtitle, this._loot, this._lvlmin, this._lvlmax, this._membersmax, _activeChar);
            LOG.info("PartyMatchRoom #{} created by {}", (Object)_maxid, (Object)_activeChar.getName());
            PartyMatchWaitingList.getInstance().removePlayer(_activeChar);
            PartyMatchRoomList.getInstance().addPartyMatchRoom(_maxid, _room);
            if (_activeChar.isInParty()) {
                for (L2PcInstance ptmember : _activeChar.getParty().getMembers()) {
                    if (ptmember == null || ptmember == _activeChar) continue;
                    ptmember.setPartyRoom(_maxid);
                    _room.addMember(ptmember);
                }
            }
            _activeChar.sendPacket(new PartyMatchDetail(_activeChar, _room));
            _activeChar.sendPacket(new ExPartyRoomMember(_activeChar, _room, 1));
            _activeChar.sendPacket(SystemMessageId.PARTY_ROOM_CREATED);
            _activeChar.setPartyRoom(_maxid);
            _activeChar.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__80_REQUESTPARTYMATCHLIST;
    }
}

