/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestPledgeInfo
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPledgeInfo.class);
    private static final String _C__65_REQUESTPLEDGEINFO = "[C] 65 RequestPledgeInfo";
    private int _clanId;

    @Override
    protected void readImpl() {
        this._clanId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar;
        if (Configuration.general().debug()) {
            LOG.debug("Info for clan {} requested", (Object)this._clanId);
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClan(this._clanId);
        if (clan == null) {
            if (Configuration.general().debug()) {
                LOG.warn("Clan data for clanId {} is missing for player {}", (Object)this._clanId, (Object)activeChar);
            }
            return;
        }
        activeChar.sendPacket(new PledgeInfo(clan));
    }

    @Override
    public String getType() {
        return _C__65_REQUESTPLEDGEINFO;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

