/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExChangePostState;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestRejectPostAttachment
extends L2GameClientPacket {
    private static final String _C__D0_6B_REQUESTREJECTPOSTATTACHMENT = "[C] D0:6B RequestRejectPostAttachment";
    private int _msgId;

    @Override
    protected void readImpl() {
        this._msgId = this.readD();
    }

    @Override
    public void runImpl() {
        if (!Configuration.general().allowMail() || !Configuration.general().allowAttachments()) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("rejectattach")) {
            return;
        }
        if (!activeChar.isInsideZone(ZoneId.PEACE)) {
            activeChar.sendPacket(SystemMessageId.CANT_USE_MAIL_OUTSIDE_PEACE_ZONE);
            return;
        }
        Message msg = MailManager.getInstance().getMessage(this._msgId);
        if (msg == null) {
            return;
        }
        if (msg.getReceiverId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to reject not own attachment!");
            return;
        }
        if (!msg.hasAttachments() || msg.getSendBySystem() != 0) {
            return;
        }
        MailManager.getInstance().sendMessage(new Message(msg));
        activeChar.sendPacket(SystemMessageId.MAIL_SUCCESSFULLY_RETURNED);
        activeChar.sendPacket(new ExChangePostState(true, this._msgId, 2));
        L2PcInstance sender = L2World.getInstance().getPlayer(msg.getSenderId());
        if (sender != null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_RETURNED_MAIL);
            sm.addCharName(activeChar);
            sender.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_6B_REQUESTREJECTPOSTATTACHMENT;
    }
}

