/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.L2FriendSay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestSendFriendMsg
extends L2GameClientPacket {
    private static final String _C__6B_REQUESTSENDMSG = "[C] 6B RequestSendFriendMsg";
    private static final Logger LOG_CHAT = LoggerFactory.getLogger("chat");
    private String _message;
    private String _receiver;

    @Override
    protected void readImpl() {
        this._message = this.readS();
        this._receiver = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._message == null || this._message.isEmpty() || this._message.length() > 300) {
            return;
        }
        L2PcInstance targetPlayer = L2World.getInstance().getPlayer(this._receiver);
        if (targetPlayer == null || !targetPlayer.isFriend(activeChar.getObjectId())) {
            activeChar.sendPacket(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
            return;
        }
        if (Configuration.general().logChat()) {
            LOG_CHAT.info("PRIV_MSG {} says [{}] to {}.", activeChar.getName(), this._message, this._receiver);
        }
        targetPlayer.sendPacket(new L2FriendSay(activeChar.getName(), this._receiver, this._message));
    }

    @Override
    public String getType() {
        return _C__6B_REQUESTSENDMSG;
    }
}

