/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestStartPledgeWar
extends L2GameClientPacket {
    private static final String _C__03_REQUESTSTARTPLEDGEWAR = "[C] 03 RequestStartPledgewar";
    private String _pledgeName;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Clan _clan = ((L2GameClient)this.getClient()).getActiveChar().getClan();
        if (_clan == null) {
            return;
        }
        if (_clan.getLevel() < 3 || _clan.getMembersCount() < Configuration.character().getClanMembersForWar()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!player.hasClanPrivilege(ClanPrivilege.CL_PLEDGE_WAR)) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_CANNOT_DECLARED_CLAN_NOT_EXIST));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (_clan.getAllyId() == clan.getAllyId() && _clan.getAllyId() != 0) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_AGAINST_A_ALLIED_CLAN_NOT_WORK));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (clan.getLevel() < 3 || clan.getMembersCount() < Configuration.character().getClanMembersForWar()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (_clan.isAtWarWith(clan.getId())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.ALREADY_AT_WAR_WITH_S1_WAIT_5_DAYS);
            sm.addString(clan.getName());
            player.sendPacket(sm);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        ClanTable.getInstance().storeclanswars(player.getClanId(), clan.getId());
        for (L2PcInstance member : _clan.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
        for (L2PcInstance member : clan.getOnlineMembers(0)) {
            member.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__03_REQUESTSTARTPLEDGEWAR;
    }
}

