/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.GMAudit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendBypassBuildCmd
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(SendBypassBuildCmd.class);
    private static final String _C__74_SENDBYPASSBUILDCMD = "[C] 74 SendBypassBuildCmd";
    public static final int GM_MESSAGE = 9;
    public static final int ANNOUNCEMENT = 10;
    private String _command;

    @Override
    protected void readImpl() {
        this._command = this.readS().trim();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        String command = "admin_" + this._command.split(" ")[0];
        IAdminCommandHandler ach = AdminCommandHandler.getInstance().getHandler(command);
        if (ach == null) {
            if (activeChar.isGM()) {
                activeChar.sendMessage("The command " + command.substring(6) + " does not exists!");
            }
            LOG.warn("No handler registered for admin command '{}'", (Object)command);
            return;
        }
        if (!AdminData.getInstance().hasAccess(command, activeChar.getAccessLevel())) {
            activeChar.sendMessage("You don't have the access right to use this command!");
            LOG.warn("Character {} tried to use admin command {}, but have no access to it!", (Object)activeChar.getName(), (Object)command);
            return;
        }
        if (Configuration.general().gmAudit()) {
            GMAudit.auditGMAction(activeChar.getName() + " [" + activeChar.getObjectId() + "]", this._command, activeChar.getTarget() != null ? activeChar.getTarget().getName() : "no-target");
        }
        ach.useAdminCommand("admin_" + this._command, activeChar);
    }

    @Override
    public String getType() {
        return _C__74_SENDBYPASSBUILDCMD;
    }
}

