/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.ItemInfo;
import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public abstract class AbstractItemPacket
extends L2GameServerPacket {
    protected void writeItem(TradeItem item) {
        this.writeItem(new ItemInfo(item));
    }

    protected void writeItem(L2ItemInstance item) {
        this.writeItem(new ItemInfo(item));
    }

    protected void writeItem(ItemInfo item) {
        this.writeD(item.getObjectId());
        this.writeD(item.getItem().getDisplayId());
        this.writeD(item.getLocation());
        this.writeQ(item.getCount());
        this.writeH(item.getItem().getType2().getId());
        this.writeH(item.getCustomType1());
        this.writeH(item.getEquipped());
        this.writeD(item.getItem().getBodyPart());
        this.writeH(item.getEnchant());
        this.writeH(item.getCustomType2());
        this.writeD(item.getAugmentationBonus());
        this.writeD(item.getMana());
        this.writeD(item.getTime());
        this.writeItemElementalAndEnchant(item);
    }

    protected void writeItemElementalAndEnchant(ItemInfo item) {
        this.writeH(item.getAttackElementType());
        this.writeH(item.getAttackElementPower());
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            this.writeH(item.getElementDefAttr(i));
        }
        for (int op : item.getEnchantOptions()) {
            this.writeH(op);
        }
    }

    protected void writeInventoryBlock(PcInventory inventory) {
        if (inventory.hasInventoryBlock()) {
            this.writeH(inventory.getBlockItems().length);
            this.writeC(inventory.getBlockMode());
            for (int i : inventory.getBlockItems()) {
                this.writeD(i);
            }
        } else {
            this.writeH(0);
        }
    }
}

