/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public abstract class AbstractNpcInfo
extends L2GameServerPacket {
    protected int _x;
    protected int _y;
    protected int _z;
    protected int _heading;
    protected int _idTemplate;
    protected boolean _isAttackable;
    protected boolean _isSummoned;
    protected int _mAtkSpd;
    protected int _pAtkSpd;
    protected final int _runSpd;
    protected final int _walkSpd;
    protected final int _swimRunSpd;
    protected final int _swimWalkSpd;
    protected final int _flyRunSpd;
    protected final int _flyWalkSpd;
    protected double _moveMultiplier;
    protected int _rhand;
    protected int _lhand;
    protected int _chest;
    protected int _enchantEffect;
    protected double _collisionHeight;
    protected double _collisionRadius;
    protected String _name = "";
    protected String _title = "";

    public AbstractNpcInfo(L2Character cha) {
        this._isSummoned = cha.isShowSummonAnimation();
        this._x = cha.getX();
        this._y = cha.getY();
        this._z = cha.getZ();
        this._heading = cha.getHeading();
        this._mAtkSpd = cha.getMAtkSpd();
        this._pAtkSpd = (int)cha.getPAtkSpd();
        this._moveMultiplier = cha.getMovementSpeedMultiplier();
        this._runSpd = (int)Math.round(cha.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = (int)Math.round(cha.getWalkSpeed() / this._moveMultiplier);
        this._swimRunSpd = (int)Math.round(cha.getSwimRunSpeed() / this._moveMultiplier);
        this._swimWalkSpd = (int)Math.round(cha.getSwimWalkSpeed() / this._moveMultiplier);
        this._flyRunSpd = cha.isFlying() ? this._runSpd : 0;
        this._flyWalkSpd = cha.isFlying() ? this._walkSpd : 0;
    }

    public static class SummonInfo
    extends AbstractNpcInfo {
        private final L2Summon _summon;
        private final int _form;
        private final int _val;

        public SummonInfo(L2Summon cha, L2Character attacker, int val) {
            super(cha);
            this._summon = cha;
            this._val = val;
            this._form = cha.getFormId();
            this._isAttackable = cha.isAutoAttackable(attacker);
            this._rhand = cha.getWeapon();
            this._lhand = 0;
            this._chest = cha.getArmor();
            this._enchantEffect = cha.getTemplate().getWeaponEnchant();
            this._name = cha.getName();
            this._title = cha.getOwner() != null && cha.getOwner().isOnline() ? cha.getOwner().getName() : "";
            this._idTemplate = cha.getTemplate().getDisplayId();
            this._collisionHeight = cha.getTemplate().getfCollisionHeight();
            this._collisionRadius = cha.getTemplate().getfCollisionRadius();
            this.setInvisible(cha.isInvisible());
        }

        @Override
        protected void writeImpl() {
            L2PcInstance activeChar;
            boolean gmSeeInvis = false;
            if (this.isInvisible() && (activeChar = ((L2GameClient)this.getClient()).getActiveChar()) != null && activeChar.canOverrideCond(PcCondOverride.SEE_ALL_PLAYERS)) {
                gmSeeInvis = true;
            }
            this.writeC(12);
            this.writeD(this._summon.getObjectId());
            this.writeD(this._idTemplate + 1000000);
            this.writeD(this._isAttackable ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._swimRunSpd);
            this.writeD(this._swimWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeF(this._moveMultiplier);
            this.writeF(this._summon.getAttackSpeedMultiplier());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._rhand);
            this.writeD(this._chest);
            this.writeD(this._lhand);
            this.writeC(1);
            this.writeC(1);
            this.writeC(this._summon.isInCombat() ? 1 : 0);
            this.writeC(this._summon.isAlikeDead() ? 1 : 0);
            this.writeC(this._val);
            this.writeD(-1);
            this.writeS(this._name);
            this.writeD(-1);
            this.writeS(this._title);
            this.writeD(1);
            this.writeD(this._summon.getPvpFlag());
            this.writeD(this._summon.getKarma());
            this.writeD(gmSeeInvis ? this._summon.getAbnormalVisualEffects() | AbnormalVisualEffect.STEALTH.getMask() : this._summon.getAbnormalVisualEffects());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(this._summon.isInsideZone(ZoneId.WATER) ? 1 : (this._summon.isFlying() ? 2 : 0));
            this.writeC(this._summon.getTeam().getId());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._enchantEffect);
            this.writeD(0);
            this.writeD(0);
            this.writeD(this._form);
            this.writeC(1);
            this.writeC(1);
            this.writeD(this._summon.getAbnormalVisualEffectSpecial());
        }
    }

    public static class TrapInfo
    extends AbstractNpcInfo {
        private final L2TrapInstance _trap;

        public TrapInfo(L2TrapInstance cha, L2Character attacker) {
            super(cha);
            this._trap = cha;
            this._idTemplate = cha.getTemplate().getDisplayId();
            this._isAttackable = cha.isAutoAttackable(attacker);
            this._rhand = 0;
            this._lhand = 0;
            this._collisionHeight = this._trap.getTemplate().getfCollisionHeight();
            this._collisionRadius = this._trap.getTemplate().getfCollisionRadius();
            if (cha.getTemplate().isUsingServerSideName()) {
                this._name = cha.getName();
            }
            this._title = cha.getOwner() != null ? cha.getOwner().getName() : "";
        }

        @Override
        protected void writeImpl() {
            this.writeC(12);
            this.writeD(this._trap.getObjectId());
            this.writeD(this._idTemplate + 1000000);
            this.writeD(this._isAttackable ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._swimRunSpd);
            this.writeD(this._swimWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeF(this._moveMultiplier);
            this.writeF(this._trap.getAttackSpeedMultiplier());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._rhand);
            this.writeD(this._chest);
            this.writeD(this._lhand);
            this.writeC(1);
            this.writeC(1);
            this.writeC(this._trap.isInCombat() ? 1 : 0);
            this.writeC(this._trap.isAlikeDead() ? 1 : 0);
            this.writeC(this._isSummoned ? 2 : 0);
            this.writeD(-1);
            this.writeS(this._name);
            this.writeD(-1);
            this.writeS(this._title);
            this.writeD(0);
            this.writeD(this._trap.getPvpFlag());
            this.writeD(this._trap.getKarma());
            this.writeD(this._trap.isInvisible() ? this._trap.getAbnormalVisualEffects() | AbnormalVisualEffect.STEALTH.getMask() : this._trap.getAbnormalVisualEffects());
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(0);
            this.writeC(this._trap.getTeam().getId());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeC(1);
            this.writeC(1);
            this.writeD(0);
        }
    }

    public static class NpcInfo
    extends AbstractNpcInfo {
        private final L2Npc _npc;
        private int _clanCrest = 0;
        private int _allyCrest = 0;
        private int _allyId = 0;
        private int _clanId = 0;
        private final int _displayEffect;

        public NpcInfo(L2Npc cha, L2Character attacker) {
            super(cha);
            int townId;
            this._npc = cha;
            this._idTemplate = cha.getTemplate().getDisplayId();
            this._rhand = cha.getRightHandItem();
            this._lhand = cha.getLeftHandItem();
            this._enchantEffect = cha.getEnchantEffect();
            this._collisionHeight = cha.getCollisionHeight();
            this._collisionRadius = cha.getCollisionRadius();
            this._isAttackable = cha.isAutoAttackable(attacker);
            if (cha.getTemplate().isUsingServerSideName()) {
                this._name = cha.getName();
            }
            this._title = this._npc.isInvisible() ? "Invisible" : (Configuration.customs().championEnable() && cha.isChampion() ? Configuration.customs().getChampionTitle() : (cha.getTemplate().isUsingServerSideTitle() ? cha.getTemplate().getTitle() : cha.getTitle()));
            if (Configuration.npc().showNpcLevel() && this._npc instanceof L2MonsterInstance) {
                StringBuilder t = new StringBuilder("Lv ").append(cha.getLevel()).append(cha.isAggressive() ? "*" : "");
                if (this._title != null) {
                    t.append(" ").append(this._title);
                }
                this._title = t.toString();
            }
            if (cha instanceof L2NpcInstance && cha.isInsideZone(ZoneId.TOWN) && (Configuration.npc().showCrestWithoutQuest() || cha.getCastle().getShowNpcCrest()) && cha.getCastle().getOwnerId() != 0 && (townId = TownManager.getTown(this._x, this._y, this._z).getTownId()) != 33 && townId != 22) {
                L2Clan clan = ClanTable.getInstance().getClan(cha.getCastle().getOwnerId());
                this._clanCrest = clan.getCrestId();
                this._clanId = clan.getId();
                this._allyCrest = clan.getAllyCrestId();
                this._allyId = clan.getAllyId();
            }
            this._displayEffect = cha.getDisplayEffect();
        }

        @Override
        protected void writeImpl() {
            this.writeC(12);
            this.writeD(this._npc.getObjectId());
            this.writeD(this._idTemplate + 1000000);
            this.writeD(this._isAttackable ? 1 : 0);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._heading);
            this.writeD(0);
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._swimRunSpd);
            this.writeD(this._swimWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeD(this._flyRunSpd);
            this.writeD(this._flyWalkSpd);
            this.writeF(this._moveMultiplier);
            this.writeF(this._npc.getAttackSpeedMultiplier());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._rhand);
            this.writeD(this._chest);
            this.writeD(this._lhand);
            this.writeC(1);
            this.writeC(this._npc.isRunning() ? 1 : 0);
            this.writeC(this._npc.isInCombat() ? 1 : 0);
            this.writeC(this._npc.isAlikeDead() ? 1 : 0);
            this.writeC(this._isSummoned ? 2 : 0);
            this.writeD(-1);
            this.writeS(this._name);
            this.writeD(-1);
            this.writeS(this._title);
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(this._npc.isInvisible() ? this._npc.getAbnormalVisualEffects() | AbnormalVisualEffect.STEALTH.getMask() : this._npc.getAbnormalVisualEffects());
            this.writeD(this._clanId);
            this.writeD(this._clanCrest);
            this.writeD(this._allyId);
            this.writeD(this._allyCrest);
            this.writeC(this._npc.isInsideZone(ZoneId.WATER) ? 1 : (this._npc.isFlying() ? 2 : 0));
            this.writeC(this._npc.getTeam().getId());
            this.writeF(this._collisionRadius);
            this.writeF(this._collisionHeight);
            this.writeD(this._enchantEffect);
            this.writeD(this._npc.isFlying() ? 1 : 0);
            this.writeD(0);
            this.writeD(this._npc.getColorEffect());
            this.writeC(this._npc.isTargetable() ? 1 : 0);
            this.writeC(this._npc.isShowName() ? 1 : 0);
            this.writeD(this._npc.getAbnormalVisualEffectSpecial());
            this.writeD(this._displayEffect);
        }
    }
}

