/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Collection;

public final class BuyList
extends L2GameServerPacket {
    private final int _listId;
    private final Collection<Product> _list;
    private final long _money;
    private final double _taxRate;

    public BuyList(L2BuyList list, long currentMoney, double taxRate) {
        this._listId = list.getListId();
        this._list = list.getProducts();
        this._money = currentMoney;
        this._taxRate = taxRate;
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(183);
        this.writeD(0);
        this.writeQ(this._money);
        this.writeD(this._listId);
        this.writeH(this._list.size());
        for (Product product : this._list) {
            if (product.getCount() <= 0L && product.hasLimitedStock()) continue;
            this.writeD(product.getItemId());
            this.writeD(product.getItemId());
            this.writeD(0);
            this.writeQ(product.getCount() < 0L ? 0L : product.getCount());
            this.writeH(product.getItem().getType2().getId());
            this.writeH(product.getItem().getType1().getId());
            this.writeH(0);
            this.writeD(product.getItem().getBodyPart());
            this.writeH(product.getItem().getDefaultEnchantLevel());
            this.writeH(0);
            this.writeD(0);
            this.writeD(-1);
            this.writeD(-9999);
            this.writeH(0);
            this.writeH(0);
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.writeH(0);
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            if (product.getItemId() >= 3960 && product.getItemId() <= 4026) {
                this.writeQ((long)((double)product.getPrice() * Configuration.rates().getRateSiegeGuardsPrice() * (1.0 + this._taxRate)));
                continue;
            }
            this.writeQ((long)((double)product.getPrice() * (1.0 + this._taxRate)));
        }
    }
}

