/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class ExShowCropInfo
extends L2GameServerPacket {
    private final List<CropProcure> _crops;
    private final int _manorId;
    private final boolean _hideButtons;

    public ExShowCropInfo(int manorId, boolean nextPeriod, boolean hideButtons) {
        this._manorId = manorId;
        this._hideButtons = hideButtons;
        CastleManorManager manor = CastleManorManager.getInstance();
        this._crops = nextPeriod && !manor.isManorApproved() ? null : manor.getCropProcure(manorId, nextPeriod);
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(36);
        this.writeC(this._hideButtons ? 1 : 0);
        this.writeD(this._manorId);
        this.writeD(0);
        if (this._crops == null) {
            this.writeD(0);
            return;
        }
        this.writeD(this._crops.size());
        for (CropProcure crop : this._crops) {
            this.writeD(crop.getId());
            this.writeQ(crop.getAmount());
            this.writeQ(crop.getStartAmount());
            this.writeQ(crop.getPrice());
            this.writeC(crop.getReward());
            L2Seed seed = CastleManorManager.getInstance().getSeedByCrop(crop.getId());
            if (seed == null) {
                this.writeD(0);
                this.writeC(1);
                this.writeD(0);
                this.writeC(1);
                this.writeD(0);
                continue;
            }
            this.writeD(seed.getLevel());
            this.writeC(1);
            this.writeD(seed.getReward(1));
            this.writeC(1);
            this.writeD(seed.getReward(2));
        }
    }
}

