/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExShowSeedSetting
extends L2GameServerPacket {
    private final int _manorId;
    private final Set<L2Seed> _seeds;
    private final Map<Integer, SeedProduction> _current = new HashMap<Integer, SeedProduction>();
    private final Map<Integer, SeedProduction> _next = new HashMap<Integer, SeedProduction>();

    public ExShowSeedSetting(int manorId) {
        CastleManorManager manor = CastleManorManager.getInstance();
        this._manorId = manorId;
        this._seeds = manor.getSeedsForCastle(this._manorId);
        for (L2Seed s : this._seeds) {
            SeedProduction sp = manor.getSeedProduct(manorId, s.getSeedId(), false);
            if (sp != null) {
                this._current.put(s.getSeedId(), sp);
            }
            if ((sp = manor.getSeedProduct(manorId, s.getSeedId(), true)) == null) continue;
            this._next.put(s.getSeedId(), sp);
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(38);
        this.writeD(this._manorId);
        this.writeD(this._seeds.size());
        for (L2Seed s : this._seeds) {
            SeedProduction sp;
            this.writeD(s.getSeedId());
            this.writeD(s.getLevel());
            this.writeC(1);
            this.writeD(s.getReward(1));
            this.writeC(1);
            this.writeD(s.getReward(2));
            this.writeD(s.getSeedLimit());
            this.writeD(s.getSeedReferencePrice());
            this.writeD(s.getSeedMinPrice());
            this.writeD(s.getSeedMaxPrice());
            if (this._current.containsKey(s.getSeedId())) {
                sp = this._current.get(s.getSeedId());
                this.writeQ(sp.getStartAmount());
                this.writeQ(sp.getPrice());
            } else {
                this.writeQ(0L);
                this.writeQ(0L);
            }
            if (this._next.containsKey(s.getSeedId())) {
                sp = this._next.get(s.getSeedId());
                this.writeQ(sp.getStartAmount());
                this.writeQ(sp.getPrice());
                continue;
            }
            this.writeQ(0L);
            this.writeQ(0L);
        }
        this._current.clear();
        this._next.clear();
    }
}

