/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FriendList
extends L2GameServerPacket {
    private final List<FriendInfo> _info;

    public FriendList(L2PcInstance player) {
        if (!player.hasFriends()) {
            this._info = Collections.emptyList();
            return;
        }
        this._info = new ArrayList<FriendInfo>(player.getFriends().size());
        for (int objId : player.getFriends()) {
            String name = CharNameTable.getInstance().getNameById(objId);
            L2PcInstance friend = L2World.getInstance().getPlayer(objId);
            boolean online = friend != null && friend.isOnline();
            this._info.add(new FriendInfo(objId, name, online));
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(117);
        this.writeD(this._info.size());
        for (FriendInfo info : this._info) {
            this.writeD(info._objId);
            this.writeS(info._name);
            this.writeD(info._online ? 1 : 0);
            this.writeD(info._online ? info._objId : 0);
        }
    }

    private static class FriendInfo {
        int _objId;
        String _name;
        boolean _online;

        public FriendInfo(int objId, String name, boolean online) {
            this._objId = objId;
            this._name = name;
            this._online = online;
        }
    }
}

