/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding.cellnodes;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.pathfinding.AbstractNode;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellNode;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellNodeBuffer;
import com.l2jserver.gameserver.pathfinding.cellnodes.NodeLoc;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellPathFinding
extends PathFinding {
    private static final Logger LOG = LoggerFactory.getLogger(CellPathFinding.class);
    private final BufferInfo[] _allBuffers;
    private int _findSuccess = 0;
    private int _findFails = 0;
    private int _postFilterUses = 0;
    private int _postFilterPlayableUses = 0;
    private int _postFilterPasses = 0;
    private long _postFilterElapsed = 0L;
    private List<L2ItemInstance> _debugItems = null;

    public static CellPathFinding getInstance() {
        return SingletonHolder._instance;
    }

    private CellPathFinding() {
        try {
            String[] array = Configuration.geodata().getPathFindBuffers().split(";");
            this._allBuffers = new BufferInfo[array.length];
            for (int i = 0; i < array.length; ++i) {
                String buf = array[i];
                String[] args = buf.split("x");
                if (args.length != 2) {
                    throw new Exception("Invalid buffer definition: " + buf);
                }
                this._allBuffers[i] = new BufferInfo(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            }
        }
        catch (Exception e) {
            LOG.warn("Problem during buffer init: {}", (Object)e.getMessage(), (Object)e);
            throw new Error("CellPathFinding: load aborted");
        }
    }

    @Override
    public boolean pathNodesExist(short regionoffset) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractNodeLoc> findPath(int x, int y, int z, int tx, int ty, int tz, int instanceId, boolean playable) {
        boolean remove;
        List<AbstractNodeLoc> path;
        Iterator<CellNode> iterator;
        boolean debug;
        int gx = GeoData.getInstance().getGeoX(x);
        int gy = GeoData.getInstance().getGeoY(y);
        if (!GeoData.getInstance().hasGeo(x, y)) {
            return null;
        }
        int gz = GeoData.getInstance().getHeight(x, y, z);
        int gtx = GeoData.getInstance().getGeoX(tx);
        int gty = GeoData.getInstance().getGeoY(ty);
        if (!GeoData.getInstance().hasGeo(tx, ty)) {
            return null;
        }
        int gtz = GeoData.getInstance().getHeight(tx, ty, tz);
        CellNodeBuffer buffer = this.alloc(64 + 2 * Math.max(Math.abs(gx - gtx), Math.abs(gy - gty)), playable);
        if (buffer == null) {
            return null;
        }
        boolean bl = debug = playable && Configuration.geodata().debugPath();
        if (debug) {
            if (this._debugItems == null) {
                this._debugItems = new CopyOnWriteArrayList<L2ItemInstance>();
            } else {
                for (L2ItemInstance item : this._debugItems) {
                    item.decayMe();
                }
                this._debugItems.clear();
            }
        }
        try {
            CellNode result = buffer.findPath(gx, gy, gz, gtx, gty, gtz);
            if (debug) {
                for (CellNode n2 : buffer.debugPath()) {
                    if (n2.getCost() < 0.0f) {
                        this.dropDebugItem(1831, (int)(-n2.getCost() * 10.0f), (AbstractNodeLoc)n2.getLoc());
                        continue;
                    }
                    this.dropDebugItem(57, (int)(n2.getCost() * 10.0f), (AbstractNodeLoc)n2.getLoc());
                }
            }
            if (result == null) {
                ++this._findFails;
                iterator = null;
                return iterator;
            }
            path = this.constructPath(result);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), e);
            iterator = null;
            return iterator;
        }
        finally {
            buffer.free();
        }
        if (path.size() < 3 || Configuration.geodata().getMaxPostfilterPasses() <= 0) {
            ++this._findSuccess;
            return path;
        }
        long timeStamp = System.currentTimeMillis();
        ++this._postFilterUses;
        if (playable) {
            ++this._postFilterPlayableUses;
        }
        int pass = 0;
        do {
            ++pass;
            ++this._postFilterPasses;
            remove = false;
            Iterator<AbstractNodeLoc> endPoint = path.iterator();
            endPoint.next();
            int currentX = x;
            int currentY = y;
            int currentZ = z;
            int midPoint = 0;
            while (endPoint.hasNext()) {
                AbstractNodeLoc locMiddle = path.get(midPoint);
                AbstractNodeLoc locEnd = endPoint.next();
                if (GeoData.getInstance().canMove(currentX, currentY, currentZ, locEnd.getX(), locEnd.getY(), locEnd.getZ(), instanceId)) {
                    path.remove(midPoint);
                    remove = true;
                    if (!debug) continue;
                    this.dropDebugItem(735, 1, locMiddle);
                    continue;
                }
                currentX = locMiddle.getX();
                currentY = locMiddle.getY();
                currentZ = locMiddle.getZ();
                ++midPoint;
            }
        } while (playable && remove && path.size() > 2 && pass < Configuration.geodata().getMaxPostfilterPasses());
        if (debug) {
            path.forEach(n -> this.dropDebugItem(65, 1, (AbstractNodeLoc)n));
        }
        ++this._findSuccess;
        this._postFilterElapsed += System.currentTimeMillis() - timeStamp;
        return path;
    }

    private List<AbstractNodeLoc> constructPath(AbstractNode<NodeLoc> node) {
        CopyOnWriteArrayList<AbstractNodeLoc> path = new CopyOnWriteArrayList<AbstractNodeLoc>();
        int previousDirectionX = Integer.MIN_VALUE;
        int previousDirectionY = Integer.MIN_VALUE;
        while (node.getParent() != null) {
            int directionY;
            int directionX;
            if (!Configuration.geodata().advancedDiagonalStrategy() && node.getParent().getParent() != null) {
                int tmpX = node.getLoc().getNodeX() - node.getParent().getParent().getLoc().getNodeX();
                int tmpY = node.getLoc().getNodeY() - node.getParent().getParent().getLoc().getNodeY();
                if (Math.abs(tmpX) == Math.abs(tmpY)) {
                    directionX = tmpX;
                    directionY = tmpY;
                } else {
                    directionX = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
                    directionY = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
                }
            } else {
                directionX = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
                directionY = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
            }
            if (directionX != previousDirectionX || directionY != previousDirectionY) {
                previousDirectionX = directionX;
                previousDirectionY = directionY;
                path.addFirst(node.getLoc());
                node.setLoc(null);
            }
            node = node.getParent();
        }
        return path;
    }

    private CellNodeBuffer alloc(int size, boolean playable) {
        CellNodeBuffer current = null;
        for (BufferInfo i : this._allBuffers) {
            if (i.mapSize < size) continue;
            for (CellNodeBuffer buf : i.bufs) {
                if (!buf.lock()) continue;
                ++i.uses;
                if (playable) {
                    ++i.playableUses;
                }
                i.elapsed += buf.getElapsedTime();
                current = buf;
                break;
            }
            if (current != null) break;
            current = new CellNodeBuffer(i.mapSize);
            current.lock();
            if (i.bufs.size() < i.count) {
                i.bufs.add(current);
                ++i.uses;
                if (!playable) break;
                ++i.playableUses;
                break;
            }
            ++i.overflows;
            if (!playable) continue;
            ++i.playableOverflows;
        }
        return current;
    }

    private void dropDebugItem(int itemId, int num, AbstractNodeLoc loc) {
        int objectId = IdFactory.getInstance().getNextId();
        L2ItemInstance item = new L2ItemInstance(objectId, itemId);
        item.setCount(num);
        item.spawnMe(loc.getX(), loc.getY(), loc.getZ());
        this._debugItems.add(item);
    }

    @Override
    public String[] getStat() {
        String[] result = new String[this._allBuffers.length + 1];
        for (int i = 0; i < this._allBuffers.length; ++i) {
            result[i] = this._allBuffers[i].toString();
        }
        StringBuilder stat = new StringBuilder(100);
        StringUtil.append(stat, "LOS postfilter uses:", String.valueOf(this._postFilterUses), "/", String.valueOf(this._postFilterPlayableUses));
        if (this._postFilterUses > 0) {
            StringUtil.append(stat, " total/avg(ms):", String.valueOf(this._postFilterElapsed), "/", String.format("%1.2f", (double)this._postFilterElapsed / (double)this._postFilterUses), " passes total/avg:", String.valueOf(this._postFilterPasses), "/", String.format("%1.1f", (double)this._postFilterPasses / (double)this._postFilterUses), Configuration.EOL);
        }
        StringUtil.append(stat, "Pathfind success/fail:", String.valueOf(this._findSuccess), "/", String.valueOf(this._findFails));
        result[result.length - 1] = stat.toString();
        return result;
    }

    private static class SingletonHolder {
        protected static final CellPathFinding _instance = new CellPathFinding();

        private SingletonHolder() {
        }
    }

    private static final class BufferInfo {
        final int mapSize;
        final int count;
        List<CellNodeBuffer> bufs;
        int uses = 0;
        int playableUses = 0;
        int overflows = 0;
        int playableOverflows = 0;
        long elapsed = 0L;

        public BufferInfo(int size, int cnt) {
            this.mapSize = size;
            this.count = cnt;
            this.bufs = new ArrayList<CellNodeBuffer>(this.count);
        }

        public String toString() {
            StringBuilder stat = new StringBuilder(100);
            StringUtil.append(stat, String.valueOf(this.mapSize), "x", String.valueOf(this.mapSize), " num:", String.valueOf(this.bufs.size()), "/", String.valueOf(this.count), " uses:", String.valueOf(this.uses), "/", String.valueOf(this.playableUses));
            if (this.uses > 0) {
                StringUtil.append(stat, " total/avg(ms):", String.valueOf(this.elapsed), "/", String.format("%1.2f", (double)this.elapsed / (double)this.uses));
            }
            StringUtil.append(stat, " ovf:", String.valueOf(this.overflows), "/", String.valueOf(this.playableOverflows));
            return stat.toString();
        }
    }
}

