/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding.cellnodes;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;

public class NodeLoc
extends AbstractNodeLoc {
    private int _x;
    private int _y;
    private boolean _goNorth;
    private boolean _goEast;
    private boolean _goSouth;
    private boolean _goWest;
    private int _geoHeight;

    public NodeLoc(int x, int y, int z) {
        this.set(x, y, z);
    }

    public void set(int x, int y, int z) {
        this._x = x;
        this._y = y;
        this._goNorth = GeoData.getInstance().checkNearestNswe(x, y, z, 8);
        this._goEast = GeoData.getInstance().checkNearestNswe(x, y, z, 1);
        this._goSouth = GeoData.getInstance().checkNearestNswe(x, y, z, 4);
        this._goWest = GeoData.getInstance().checkNearestNswe(x, y, z, 2);
        this._geoHeight = GeoData.getInstance().getNearestZ(x, y, z);
    }

    public boolean canGoNorth() {
        return this._goNorth;
    }

    public boolean canGoEast() {
        return this._goEast;
    }

    public boolean canGoSouth() {
        return this._goSouth;
    }

    public boolean canGoWest() {
        return this._goWest;
    }

    public boolean canGoNone() {
        return !this.canGoNorth() && !this.canGoEast() && !this.canGoSouth() && !this.canGoWest();
    }

    public boolean canGoAll() {
        return this.canGoNorth() && this.canGoEast() && this.canGoSouth() && this.canGoWest();
    }

    @Override
    public int getX() {
        return GeoData.getInstance().getWorldX(this._x);
    }

    @Override
    public int getY() {
        return GeoData.getInstance().getWorldY(this._y);
    }

    @Override
    public int getZ() {
        return this._geoHeight;
    }

    @Override
    public void setZ(short z) {
    }

    @Override
    public int getNodeX() {
        return this._x;
    }

    @Override
    public int getNodeY() {
        return this._y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._x;
        result = 31 * result + this._y;
        int nswe = 0;
        if (this.canGoNorth()) {
            nswe |= 8;
        }
        if (this.canGoEast()) {
            nswe |= 1;
        }
        if (this.canGoSouth()) {
            nswe |= 4;
        }
        if (this.canGoWest()) {
            nswe |= 2;
        }
        result = 31 * result + ((this._geoHeight & 0xFFFF) << 1 | nswe);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeLoc)) {
            return false;
        }
        NodeLoc other = (NodeLoc)obj;
        if (this._x != other._x) {
            return false;
        }
        if (this._y != other._y) {
            return false;
        }
        if (this._goNorth != other._goNorth) {
            return false;
        }
        if (this._goEast != other._goEast) {
            return false;
        }
        if (this._goSouth != other._goSouth) {
            return false;
        }
        if (this._goWest != other._goWest) {
            return false;
        }
        return this._geoHeight == other._geoHeight;
    }
}

