/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRange {
    private static final Logger LOG = LoggerFactory.getLogger(DateRange.class);
    private final Date _startDate;
    private final Date _endDate;

    private DateRange(Date from, Date to) {
        this._startDate = from;
        this._endDate = to;
    }

    public static DateRange parse(String dateRange, DateFormat format) {
        String[] date = dateRange.split("-");
        if (date.length == 2) {
            try {
                Date start = format.parse(date[0]);
                Date end = format.parse(date[1]);
                return new DateRange(start, end);
            }
            catch (ParseException e) {
                LOG.warn("Invalid Date Format.", e);
            }
        }
        return new DateRange(null, null);
    }

    public boolean isValid() {
        return this._startDate != null && this._endDate != null && this._startDate.before(this._endDate);
    }

    public boolean isWithinRange(Date date) {
        return !(!date.equals(this._startDate) && !date.after(this._startDate) || !date.equals(this._endDate) && !date.before(this._endDate));
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public String toString() {
        return "DateRange: From: " + String.valueOf(this.getStartDate()) + " To: " + String.valueOf(this.getEndDate());
    }
}

