/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserNotCreatedException;
import com.l2jserver.gameserver.script.ScriptDocument;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.util.file.filter.XMLFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class FaenorScriptEngine
extends ScriptEngine {
    private static final Logger LOG = LoggerFactory.getLogger(FaenorScriptEngine.class);
    public static final String PACKAGE_DIRECTORY = "data/faenor/";

    protected FaenorScriptEngine() {
        File packDirectory = new File(Configuration.server().getDatapackRoot(), PACKAGE_DIRECTORY);
        File[] files = packDirectory.listFiles(new XMLFilter());
        if (files != null) {
            for (File file : files) {
                try (FileInputStream in = new FileInputStream(file);){
                    this.parseScript(new ScriptDocument(file.getName(), in), null);
                }
                catch (IOException ex) {
                    LOG.warn("There has been an error parsing Faenor XMLs!", ex);
                }
            }
        }
    }

    public void parseScript(ScriptDocument script, ScriptContext context) {
        Node node = script.getDocument().getFirstChild();
        String parserClass = "faenor.Faenor" + node.getNodeName() + "Parser";
        Parser parser = null;
        try {
            parser = FaenorScriptEngine.createParser(parserClass);
        }
        catch (ParserNotCreatedException ex) {
            LOG.warn("No parser registered for script {}!", (Object)parserClass, (Object)ex);
        }
        if (parser == null) {
            LOG.warn("Unknown script type {}!", (Object)script.getName());
            return;
        }
        try {
            parser.parseScript(node, context);
            LOG.info("Loaded {} successfully.", (Object)script.getName());
        }
        catch (Exception ex) {
            LOG.warn("Script parsing failed!", ex);
        }
    }

    public static FaenorScriptEngine getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final FaenorScriptEngine INSTANCE = new FaenorScriptEngine();

        private SingletonHolder() {
        }
    }
}

