/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.status;

import com.l2jserver.commons.util.Util;
import com.l2jserver.gameserver.status.GameStatusThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Status.class);
    private final ServerSocket statusServerSocket;
    private final int _uptime;
    private String _statusPw;

    public Status(int statusPort, String statusPw) throws IOException {
        super("Status");
        this._statusPw = statusPw;
        if (this._statusPw == null) {
            this._statusPw = Util.randomPassword((int)10);
            LOG.info("Server's Telnet function has no password defined!");
            LOG.info("A password has been automatically created!");
            LOG.info("Password has been set to: {}", (Object)this._statusPw);
        }
        this.statusServerSocket = new ServerSocket(statusPort);
        this._uptime = (int)System.currentTimeMillis();
        LOG.info("Telnet server started successfully, listening on port {}.", (Object)statusPort);
    }

    @Override
    public void run() {
        this.setPriority(10);
        while (!this.isInterrupted()) {
            try {
                Socket connection = this.statusServerSocket.accept();
                new GameStatusThread(connection, this._uptime, this._statusPw);
                if (!this.isInterrupted()) continue;
                try {
                    this.statusServerSocket.close();
                }
                catch (Exception ex) {
                    LOG.warn("There has been an error closing status server socket!", ex);
                }
            }
            catch (Exception ex1) {
                if (!this.isInterrupted()) continue;
                try {
                    this.statusServerSocket.close();
                }
                catch (Exception ex2) {
                    LOG.warn("There has been an error closing status server socket!", ex2);
                }
            }
            break;
        }
    }
}

