/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class DecayTaskManager {
    private final ScheduledExecutorService _decayExecutor = Executors.newSingleThreadScheduledExecutor();
    protected final Map<L2Character, ScheduledFuture<?>> _decayTasks = new ConcurrentHashMap();

    public void add(L2Character character) {
        if (character == null) {
            return;
        }
        long delay = character.getTemplate() instanceof L2NpcTemplate ? (long)((L2NpcTemplate)character.getTemplate()).getCorpseTime() : (long)Configuration.npc().getDefaultCorpseTime();
        if (character instanceof L2Attackable && (((L2Attackable)character).isSpoiled() || ((L2Attackable)character).isSeeded())) {
            delay += (long)Configuration.npc().getSpoiledCorpseExtendTime();
        }
        this.add(character, delay, TimeUnit.SECONDS);
    }

    public void add(L2Character character, long delay, TimeUnit timeUnit) {
        ScheduledFuture<?> decayTask = this._decayExecutor.schedule(new DecayTask(character), delay, TimeUnit.SECONDS);
        if ((decayTask = this._decayTasks.put(character, decayTask)) != null && !decayTask.cancel(false) && (decayTask = this._decayTasks.remove(character)) != null) {
            decayTask.cancel(false);
        }
    }

    public void cancel(L2Character character) {
        ScheduledFuture<?> decayTask = this._decayTasks.remove(character);
        if (decayTask != null) {
            decayTask.cancel(false);
        }
    }

    public long getRemainingTime(L2Character character) {
        ScheduledFuture<?> decayTask = this._decayTasks.get(character);
        if (decayTask != null) {
            return decayTask.getDelay(TimeUnit.MILLISECONDS);
        }
        return Long.MAX_VALUE;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("============= DecayTask Manager Report ============");
        ret.append(Configuration.EOL);
        ret.append("Tasks count: ");
        ret.append(this._decayTasks.size());
        ret.append(Configuration.EOL);
        ret.append("Tasks dump:");
        ret.append(Configuration.EOL);
        for (Map.Entry<L2Character, ScheduledFuture<?>> entry : this._decayTasks.entrySet()) {
            ret.append("Class/Name: ");
            ret.append(entry.getKey().getClass().getSimpleName());
            ret.append('/');
            ret.append(entry.getKey().getName());
            ret.append(" decay timer: ");
            ret.append(entry.getValue().getDelay(TimeUnit.MILLISECONDS));
            ret.append(Configuration.EOL);
        }
        return ret.toString();
    }

    public static DecayTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    private class DecayTask
    implements Runnable {
        private final L2Character _character;

        protected DecayTask(L2Character character) {
            this._character = character;
        }

        @Override
        public void run() {
            DecayTaskManager.this._decayTasks.remove(this._character);
            this._character.onDecay();
        }
    }

    private static class SingletonHolder {
        protected static final DecayTaskManager _instance = new DecayTaskManager();

        private SingletonHolder() {
        }
    }
}

