/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDailySkillReuseClean
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDailySkillReuseClean.class);
    private static final String NAME = "daily_skill_clean";
    private static final int[] DAILY_SKILLS = new int[]{2510, 22180};

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            for (int skill_id : DAILY_SKILLS) {
                try (PreparedStatement ps = con.prepareStatement("DELETE FROM character_skills_save WHERE skill_id=?");){
                    ps.setInt(1, skill_id);
                    ps.execute();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not reset daily skill reuse!", ex);
        }
        LOG.info("Daily skill reuse cleaned.");
    }

    @Override
    public void initializate() {
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

