/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExNevitAdventTimeChange;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHuntingSystem
extends Task {
    protected static final Logger LOG = LoggerFactory.getLogger(TaskHuntingSystem.class);
    private static final String NAME = "hunting_system";
    private static final int RESET_HUNTING_BONUS = 0;
    private static final String UPDATE_CHARACTERS_HUNTING = "UPDATE characters SET hunting_bonus=?";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            player.getHuntingSystem().setHuntingBonusTime(0);
            if (!player.isOnline() || !player.getHuntingSystem().isHuntingBonusTaskActive()) continue;
            player.sendPacket(new ExNevitAdventTimeChange(player.getHuntingSystem().getHuntingBonusTime(), false));
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_CHARACTERS_HUNTING);){
            ps.setInt(1, 0);
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to execute SQL-Query for the reset of the Hunting-System!", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        LOG.info("Hunting System reseted.");
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

