/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRaidPointsReset
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRaidPointsReset.class);
    public static final String NAME = "raid_points_reset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Calendar cal = Calendar.getInstance();
        if (cal.get(7) == 2) {
            Map<Integer, Integer> rankList = RaidBossPointsManager.getInstance().getRankList();
            for (L2Clan c : ClanTable.getInstance().getClans()) {
                for (Map.Entry<Integer, Integer> entry : rankList.entrySet()) {
                    if (entry.getValue() > 100 || !c.isMember(entry.getKey())) continue;
                    int reputation = switch (entry.getValue()) {
                        case 1 -> Configuration.clan().get1stRaidRankingPoints();
                        case 2 -> Configuration.clan().get2ndRaidRankingPoints();
                        case 3 -> Configuration.clan().get3rdRaidRankingPoints();
                        case 4 -> Configuration.clan().get4thRaidRankingPoints();
                        case 5 -> Configuration.clan().get5thRaidRankingPoints();
                        case 6 -> Configuration.clan().get6thRaidRankingPoints();
                        case 7 -> Configuration.clan().get7thRaidRankingPoints();
                        case 8 -> Configuration.clan().get8thRaidRankingPoints();
                        case 9 -> Configuration.clan().get9thRaidRankingPoints();
                        case 10 -> Configuration.clan().get10thRaidRankingPoints();
                        default -> entry.getValue() <= 50 ? Configuration.clan().getUpTo50thRaidRankingPoints() : Configuration.clan().getUpTo100thRaidRankingPoints();
                    };
                    c.addReputationScore(reputation, true);
                }
            }
            RaidBossPointsManager.getInstance().cleanUp();
            LOG.info("Raid points reset global task launched.");
        }
    }

    @Override
    public void initializate() {
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "00:10:00", "");
    }
}

