/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRecom
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRecom.class);
    private static final String NAME = "recommendations";
    private static final int RESET_REC_LEFT = 20;
    private static final int RESET_REC_BONUS_TIME = 3600;
    private static final String UPDATE_CHARACTERS_RECO = "UPDATE character_reco_bonus SET rec_have=rec_have-LEAST(rec_have,20), rec_left=?, time_left=?";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            player.getRecSystem().setHave(player.getRecSystem().getHave() - 20);
            player.getRecSystem().setLeft(20);
            player.getRecSystem().setBonusTime(3600);
            if (!player.isOnline()) continue;
            player.sendPacket(new UserInfo(player));
            player.sendPacket(new ExBrExtraUserInfo(player));
            player.sendPacket(new ExVoteSystemInfo(player));
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(UPDATE_CHARACTERS_RECO);){
            ps.setInt(1, 20);
            ps.setInt(2, 3600);
            ps.executeUpdate();
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to execute SQL-Query for the reset of the Recommendations System!", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        LOG.info("Recommendations System reseted.");
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

