/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.PageResult;
import com.l2jserver.gameserver.util.StringUtil;
import com.l2jserver.gameserver.util.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class HtmlUtil {
    public static String getCpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_CP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_CP_Center", 17L, -13L);
    }

    public static String getHpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_HP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_HP_Center", 17L, -13L);
    }

    public static String getHpWarnGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_HPWarn_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_HPWarn_Center", 17L, -13L);
    }

    public static String getHpFillGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_HPFill_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_HPFill_Center", 17L, -13L);
    }

    public static String getMpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_MP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_MP_Center", 17L, -13L);
    }

    public static String getExpGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_EXP_bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_EXP_Center", 17L, -13L);
    }

    public static String getFoodGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_Food_Bg_Center", "L2UI_CT1.Gauges.Gauge_DF_Large_Food_Center", 17L, -13L);
    }

    public static String getWeightGauge(int width, long current, long max, boolean displayAsPercentage) {
        return HtmlUtil.getWeightGauge(width, current, max, displayAsPercentage, Util.map(current, 0L, max, 1L, 5L));
    }

    public static String getWeightGauge(int width, long current, long max, boolean displayAsPercentage, long level) {
        return HtmlUtil.getGauge(width, current, max, displayAsPercentage, "L2UI_CT1.Gauges.Gauge_DF_Large_Weight_bg_Center" + level, "L2UI_CT1.Gauges.Gauge_DF_Large_Weight_Center" + level, 17L, -13L);
    }

    private static String getGauge(int width, long current, long max, boolean displayAsPercentage, String backgroundImage, String image, long imageHeight, long top) {
        current = Math.min(current, max);
        StringBuilder sb = new StringBuilder();
        StringUtil.append(sb, "<table width=", String.valueOf(width), " cellpadding=0 cellspacing=0><tr><td background=\"" + backgroundImage + "\">");
        StringUtil.append(sb, "<img src=\"" + image + "\" width=", String.valueOf((long)((double)current / (double)max * (double)width)), " height=", String.valueOf(imageHeight), ">");
        StringUtil.append(sb, "</td></tr><tr><td align=center><table cellpadding=0 cellspacing=", String.valueOf(top), "><tr><td>");
        if (displayAsPercentage) {
            StringUtil.append(sb, "<table cellpadding=0 cellspacing=2><tr><td>", String.format("%.2f%%", (double)current / (double)max * 100.0), "</td></tr></table>");
        } else {
            String tdWidth = String.valueOf((width - 10) / 2);
            StringUtil.append(sb, "<table cellpadding=0 cellspacing=0><tr><td width=" + tdWidth + " align=right>", String.valueOf(current), "</td>");
            StringUtil.append(sb, "<td width=10 align=center>/</td><td width=" + tdWidth + ">", String.valueOf(max), "</td></tr></table>");
        }
        StringUtil.append(sb, "</td></tr></table></td></tr></table>");
        return sb.toString();
    }

    public static <T> PageResult createPage(Collection<T> elements, int page, int elementsPerPage, Function<Integer, String> pagerFunction, Function<T, String> bodyFunction) {
        return HtmlUtil.createPage(elements, elements.size(), page, elementsPerPage, pagerFunction, bodyFunction);
    }

    public static <T> PageResult createPage(T[] elements, int page, int elementsPerPage, Function<Integer, String> pagerFunction, Function<T, String> bodyFunction) {
        return HtmlUtil.createPage(Arrays.asList(elements), elements.length, page, elementsPerPage, pagerFunction, bodyFunction);
    }

    public static <T> PageResult createPage(Iterable<T> elements, int size, int page, int elementsPerPage, Function<Integer, String> pagerFunction, Function<T, String> bodyFunction) {
        int pages = size / elementsPerPage;
        if (elementsPerPage * pages < size) {
            ++pages;
        }
        StringBuilder pagerTemplate = new StringBuilder();
        if (pages > 1) {
            int breakit = 0;
            for (int i = 0; i < pages; ++i) {
                pagerTemplate.append(pagerFunction.apply(i));
                if (++breakit <= 5) continue;
                pagerTemplate.append("</tr><tr>");
                breakit = 0;
            }
        }
        if (page >= pages) {
            page = pages - 1;
        }
        int start = 0;
        if (page > 0) {
            start = elementsPerPage * page;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (T element : elements) {
            if (i++ < start) continue;
            sb.append(bodyFunction.apply(element));
            if (i < elementsPerPage + start) continue;
            break;
        }
        return new PageResult(pages, pagerTemplate, sb);
    }
}

