/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.MinionHolder;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinionList {
    private static final Logger LOG = LoggerFactory.getLogger(MinionList.class);
    protected final L2MonsterInstance _master;
    private final List<L2MonsterInstance> _minionReferences = new CopyOnWriteArrayList<L2MonsterInstance>();
    protected List<L2MonsterInstance> _reusedMinionReferences = null;

    public MinionList(L2MonsterInstance pMaster) {
        if (pMaster == null) {
            throw new NullPointerException("MinionList: master is null");
        }
        this._master = pMaster;
    }

    public List<L2MonsterInstance> getSpawnedMinions() {
        return this._minionReferences;
    }

    public final void spawnMinions(List<MinionHolder> minions) {
        if (this._master.isAlikeDead()) {
            return;
        }
        if (minions == null) {
            return;
        }
        for (MinionHolder minion : minions) {
            int minionId;
            int minionCount = minion.getCount();
            long minionsToSpawn = (long)minionCount - this.countSpawnedMinionsById(minionId = minion.getId());
            if (minionsToSpawn <= 0L) continue;
            int i = 0;
            while ((long)i < minionsToSpawn) {
                this.spawnMinion(minionId);
                ++i;
            }
        }
        this.deleteReusedMinions();
    }

    public void deleteSpawnedMinions() {
        if (!this._minionReferences.isEmpty()) {
            for (L2MonsterInstance minion : this._minionReferences) {
                if (minion == null) continue;
                minion.setLeader(null);
                DecayTaskManager.getInstance().add(minion);
                if (this._reusedMinionReferences == null) continue;
                this._reusedMinionReferences.add(minion);
            }
            this._minionReferences.clear();
        }
    }

    public void deleteReusedMinions() {
        if (this._reusedMinionReferences != null) {
            this._reusedMinionReferences.clear();
        }
    }

    public void onMasterSpawn() {
        this.deleteSpawnedMinions();
        if (this._reusedMinionReferences == null && this._master.getTemplate().getParameters().getSet().get("SummonPrivateRate") == null && !this._master.getTemplate().getParameters().getMinionList("Privates").isEmpty() && this._master.getSpawn() != null && this._master.getSpawn().isRespawnEnabled()) {
            this._reusedMinionReferences = new CopyOnWriteArrayList<L2MonsterInstance>();
        }
    }

    public void onMinionSpawn(L2MonsterInstance minion) {
        this._minionReferences.add(minion);
    }

    public void onMasterDie(boolean force) {
        if (this._master.isRaid() || force) {
            this.deleteSpawnedMinions();
        }
    }

    public void onMinionDie(L2MonsterInstance minion, int respawnTime) {
        long time;
        minion.setLeader(null);
        this._minionReferences.remove(minion);
        if (this._reusedMinionReferences != null) {
            this._reusedMinionReferences.add(minion);
        }
        long l = respawnTime < 0 ? (this._master.isRaid() ? Configuration.npc().getRaidMinionRespawnTime() : 0L) : (time = (long)respawnTime);
        if (time > 0L && !this._master.isAlikeDead()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new MinionRespawnTask(minion), time);
        }
    }

    public void onAssist(L2Character caller, L2Character attacker) {
        int aggro;
        if (attacker == null) {
            return;
        }
        if (!this._master.isAlikeDead() && !this._master.isInCombat()) {
            this._master.addDamageHate(attacker, 0, 1L);
        }
        boolean callerIsMaster = caller == this._master;
        int n = aggro = callerIsMaster ? 10 : 1;
        if (this._master.isRaid()) {
            aggro *= 10;
        }
        for (L2MonsterInstance minion : this._minionReferences) {
            if (minion == null || minion.isDead() || !callerIsMaster && minion.isInCombat()) continue;
            minion.addDamageHate(attacker, 0, aggro);
        }
    }

    public void onMasterTeleported() {
        int offset = 200;
        int minRadius = (int)this._master.getCollisionRadius() + 30;
        for (L2MonsterInstance minion : this._minionReferences) {
            if (minion == null || minion.isDead() || minion.isMovementDisabled()) continue;
            int newX = Rnd.get((int)(minRadius * 2), (int)400);
            int newY = Rnd.get((int)newX, (int)400);
            newY = (int)Math.sqrt(newY * newY - newX * newX);
            newX = newX > 200 + minRadius ? this._master.getX() + newX - 200 : this._master.getX() - newX + minRadius;
            newY = newY > 200 + minRadius ? this._master.getY() + newY - 200 : this._master.getY() - newY + minRadius;
            minion.teleToLocation(new Location(newX, newY, this._master.getZ()));
        }
    }

    private void spawnMinion(int minionId) {
        L2MonsterInstance minion;
        if (minionId == 0) {
            return;
        }
        if (this._reusedMinionReferences != null && (minion = (L2MonsterInstance)this._reusedMinionReferences.stream().filter(m -> m.getId() == minionId).findFirst().orElse(null)) != null) {
            this._reusedMinionReferences.remove(minion);
            minion.refreshID();
            MinionList.initializeNpcInstance(this._master, minion);
            return;
        }
        MinionList.spawnMinion(this._master, minionId);
    }

    public static L2MonsterInstance spawnMinion(L2MonsterInstance master, int minionId) {
        int objectId = IdFactory.getInstance().getNextId();
        L2NpcTemplate template = NpcData.getInstance().getTemplate(minionId);
        return MinionList.initializeNpcInstance(master, new L2MonsterInstance(objectId, template));
    }

    protected static L2MonsterInstance initializeNpcInstance(L2MonsterInstance master, L2MonsterInstance minion) {
        minion.stopAllEffects();
        minion.setIsDead(false);
        minion.setDecayed(false);
        minion.setCurrentHpMp(minion.getMaxHp(), minion.getMaxMp());
        minion.setHeading(master.getHeading());
        minion.setLeader(master);
        minion.setInstanceId(master.getInstanceId());
        int offset = 200;
        int minRadius = (int)master.getCollisionRadius() + 30;
        int newX = Rnd.get((int)(minRadius * 2), (int)400);
        int newY = Rnd.get((int)newX, (int)400);
        newY = (int)Math.sqrt(newY * newY - newX * newX);
        newX = newX > 200 + minRadius ? master.getX() + newX - 200 : master.getX() - newX + minRadius;
        newY = newY > 200 + minRadius ? master.getY() + newY - 200 : master.getY() - newY + minRadius;
        minion.spawnMe(newX, newY, master.getZ());
        if (Configuration.general().debug()) {
            LOG.info("Spawned minion template {} with object Id: {} to boss object Id {}, at: {} x, {} y, {} z", minion.getId(), minion.getObjectId(), master.getObjectId(), minion.getX(), minion.getY(), minion.getZ());
        }
        return minion;
    }

    private long countSpawnedMinionsById(int minionId) {
        return this._minionReferences.stream().filter(npc -> npc.getId() == minionId).count();
    }

    public final int countSpawnedMinions() {
        return this._minionReferences.size();
    }

    public final long lazyCountSpawnedMinionsGroups() {
        return this._minionReferences.stream().map(L2Npc::getId).distinct().count();
    }

    private final class MinionRespawnTask
    implements Runnable {
        private final L2MonsterInstance _minion;

        public MinionRespawnTask(L2MonsterInstance minion) {
            this._minion = minion;
        }

        @Override
        public void run() {
            if (!MinionList.this._master.isAlikeDead() && MinionList.this._master.isVisible() && !this._minion.isVisible()) {
                if (MinionList.this._reusedMinionReferences != null) {
                    MinionList.this._reusedMinionReferences.remove(this._minion);
                }
                this._minion.refreshID();
                MinionList.initializeNpcInstance(MinionList.this._master, this._minion);
            }
        }
    }
}

