/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import java.util.Calendar;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameTimeController
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(GameTimeController.class);
    public static final int TICKS_PER_SECOND = 10;
    public static final int MILLIS_IN_TICK = 100;
    public static final int IG_DAYS_PER_DAY = 6;
    public static final int MILLIS_PER_IG_DAY = 14400000;
    public static final int SECONDS_PER_IG_DAY = 14400;
    public static final int MINUTES_PER_IG_DAY = 240;
    public static final int TICKS_PER_IG_DAY = 144000;
    public static final int TICKS_PER_IG_HOUR = 6000;
    public static final int TICKS_PER_IG_MINUTE = 100;
    public static final int TICKS_SUN_STATE_CHANGE = 36000;
    private static GameTimeController _instance;
    private final Set<L2Character> _movingObjects = ConcurrentHashMap.newKeySet();
    private final long _referenceTime;

    private GameTimeController() {
        super("GameTimeController");
        super.setDaemon(true);
        super.setPriority(10);
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this._referenceTime = c.getTimeInMillis();
        super.start();
    }

    public static void init() {
        _instance = new GameTimeController();
    }

    public int getGameTime() {
        return this.getGameTicks() % 144000 / 100;
    }

    public int getGameHour() {
        return this.getGameTime() / 60;
    }

    public int getGameMinute() {
        return this.getGameTime() % 60;
    }

    public boolean isNight() {
        return this.getGameHour() < 6;
    }

    public int getGameTicks() {
        return (int)((System.currentTimeMillis() - this._referenceTime) / 100L);
    }

    public void registerMovingObject(L2Character cha) {
        if (cha == null) {
            return;
        }
        this._movingObjects.add(cha);
    }

    private void moveObjects() {
        this._movingObjects.removeIf(L2Character::updatePosition);
    }

    public void stopTimer() {
        super.interrupt();
        LOG.info("Stopping {}", (Object)this.getClass().getSimpleName());
    }

    @Override
    public void run() {
        LOG.debug("{}: Started.", (Object)this.getClass().getSimpleName());
        boolean isNight = this.isNight();
        if (isNight) {
            ThreadPoolManager.getInstance().executeAi(() -> DayNightSpawnManager.getInstance().notifyChangeMode());
        }
        while (true) {
            long nextTickTime = System.currentTimeMillis() + 100L;
            try {
                this.moveObjects();
            }
            catch (Throwable e) {
                LOG.warn("Unable to move objects!", e);
            }
            long sleepTime = nextTickTime - System.currentTimeMillis();
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.isNight() == isNight) continue;
            isNight = !isNight;
            ThreadPoolManager.getInstance().executeAi(() -> DayNightSpawnManager.getInstance().notifyChangeMode());
        }
    }

    public static GameTimeController getInstance() {
        return _instance;
    }
}

