/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.L2VehicleAI;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.VehicleDeparture;
import com.l2jserver.gameserver.network.serverpackets.VehicleInfo;
import com.l2jserver.gameserver.network.serverpackets.VehicleStarted;

public class L2BoatAI
extends L2VehicleAI {
    public L2BoatAI(L2BoatInstance creature) {
        super(creature);
    }

    @Override
    protected void moveTo(int x, int y, int z) {
        if (!this._actor.isMovementDisabled()) {
            if (!this._clientMoving) {
                this._actor.broadcastPacket(new VehicleStarted(this.getActor(), 1));
            }
            this._clientMoving = true;
            this._actor.moveToLocation(x, y, z, 0);
            this._actor.broadcastPacket(new VehicleDeparture(this.getActor()));
        }
    }

    @Override
    protected void clientStopMoving(Location loc) {
        if (this._actor.isMoving()) {
            this._actor.stopMove(loc);
        }
        if (this._clientMoving || loc != null) {
            this._clientMoving = false;
            this._actor.broadcastPacket(new VehicleStarted(this.getActor(), 0));
            this._actor.broadcastPacket(new VehicleInfo(this.getActor()));
        }
    }

    @Override
    public void describeStateToPlayer(L2PcInstance player) {
        if (this._clientMoving) {
            player.sendPacket(new VehicleDeparture(this.getActor()));
        }
    }

    @Override
    public L2BoatInstance getActor() {
        return (L2BoatInstance)this._actor;
    }
}

