/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.AbstractAI;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2PlayerAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.NpcMoveFinished;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.AffectScope;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class L2CharacterAI
extends AbstractAI {
    protected static final int FEAR_RANGE = 500;

    public L2CharacterAI(L2Character creature) {
        super(creature);
    }

    public IntentionCommand getNextIntention() {
        return null;
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        if (attacker instanceof L2Attackable && !attacker.isCoreAIDisabled()) {
            this.clientStartAutoAttack();
        }
    }

    @Override
    protected void onIntentionIdle() {
        this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        this.setCastTarget(null);
        this.setAttackTarget(null);
        this.clientStopMoving(null);
        this.clientStopAutoAttack();
    }

    @Override
    protected void onIntentionActive() {
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ACTIVE) {
            this.changeIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
            this.setCastTarget(null);
            this.setAttackTarget(null);
            this.clientStopMoving(null);
            this.clientStopAutoAttack();
            L2Character l2Character = this._actor;
            if (l2Character instanceof L2Attackable) {
                L2Attackable attackable = (L2Attackable)l2Character;
                attackable.startRandomAnimationTimer();
            }
            this.onEvtThink();
        }
    }

    @Override
    protected void onIntentionRest() {
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        if (target == null) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAfraid()) {
            this.clientActionFailed();
            if (this._actor.isPlayer()) {
                ((L2PlayerAI)this).saveNextIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
            }
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
            if (this.getAttackTarget() != target) {
                this.setAttackTarget(target);
                this.stopFollow();
                this.notifyEvent(CtrlEvent.EVT_THINK);
            } else {
                this.clientActionFailed();
            }
        } else {
            this.changeIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
            this.setAttackTarget(target);
            this.stopFollow();
            this.notifyEvent(CtrlEvent.EVT_THINK);
        }
    }

    @Override
    protected void onIntentionCast(Skill skill, L2Object target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST && skill.isMagic()) {
            this.clientActionFailed();
            this._actor.setIsCastingNow(false);
            return;
        }
        if (this._actor.isAttackingNow()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new CastTask(this._actor, skill, target), TimeUnit.MILLISECONDS.convert(this._actor.getAttackEndTime() - System.nanoTime(), TimeUnit.NANOSECONDS));
        } else {
            this.changeIntentionToCast(skill, target);
        }
    }

    protected void changeIntentionToCast(Skill skill, L2Object target) {
        this.setCastTarget((L2Character)target);
        this._skill = skill;
        this.changeIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        this.notifyEvent(CtrlEvent.EVT_THINK);
    }

    @Override
    protected void onIntentionMoveTo(Location loc) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAttackingNow()) {
            this.clientActionFailed();
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_MOVE_TO, loc, null);
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveTo(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    protected void onIntentionFollow(L2Character target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAttackingNow()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isMovementDisabled()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isDead()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor == target) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        this.changeIntention(CtrlIntention.AI_INTENTION_FOLLOW, target, null);
        this.startFollow(target);
    }

    @Override
    protected void onIntentionPickUp(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAttackingNow()) {
            this.clientActionFailed();
            if (this._actor.isPlayer()) {
                ((L2PlayerAI)this).saveNextIntention(CtrlIntention.AI_INTENTION_PICK_UP, object, null);
            }
            return;
        }
        this.clientStopAutoAttack();
        if (object instanceof L2ItemInstance && ((L2ItemInstance)object).getItemLocation() != ItemLocation.VOID) {
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_PICK_UP, object, null);
        this.setTarget(object);
        if (object.getX() == 0 && object.getY() == 0) {
            LOG.warn("Object in coords 0,0 - using a temporary fix");
            object.setXYZ(this.getActor().getX(), this.getActor().getY(), this.getActor().getZ() + 5);
        }
        this.moveToPawn(object, 20);
    }

    @Override
    protected void onIntentionInteract(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAttackingNow()) {
            this.clientActionFailed();
            if (this._actor.isPlayer()) {
                ((L2PlayerAI)this).saveNextIntention(CtrlIntention.AI_INTENTION_INTERACT, object, null);
            }
            return;
        }
        this.clientStopAutoAttack();
        if (this.getIntention() != CtrlIntention.AI_INTENTION_INTERACT) {
            this.changeIntention(CtrlIntention.AI_INTENTION_INTERACT, object, null);
            this.setTarget(object);
            this.moveToPawn(object, 60);
        }
    }

    @Override
    protected void onEvtThink() {
    }

    @Override
    protected void onEvtAggression(L2Character target, long aggro) {
    }

    @Override
    protected void onEvtStunned(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtSleeping(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
    }

    @Override
    protected void onEvtRooted(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtConfused(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtMuted(L2Character attacker) {
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtEvaded(L2Character attacker) {
    }

    @Override
    protected void onEvtReadyToAct() {
        this.onEvtThink();
    }

    @Override
    protected void onEvtUserCmd(Object arg0, Object arg1) {
    }

    @Override
    protected void onEvtArrived() {
        this._actor.revalidateZone(true);
        if (this._actor.moveToNextRoutePoint()) {
            return;
        }
        L2Character l2Character = this._actor;
        if (l2Character instanceof L2Attackable) {
            L2Attackable attackable = (L2Attackable)l2Character;
            attackable.setisReturningToSpawnPoint(false);
        }
        this.clientStoppedMoving();
        l2Character = this._actor;
        if (l2Character instanceof L2Npc) {
            L2Npc npc = (L2Npc)l2Character;
            WalkingManager.getInstance().onArrived(npc);
            EventDispatcher.getInstance().notifyEventAsync(new NpcMoveFinished(npc), npc);
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.onEvtThink();
    }

    @Override
    protected void onEvtArrivedRevalidate() {
        this.onEvtThink();
    }

    @Override
    protected void onEvtArrivedBlocked(Location blocked_at_loc) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO || this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.clientStopMoving(blocked_at_loc);
        this.onEvtThink();
    }

    @Override
    protected void onEvtForgetObject(L2Object object) {
        if (this.getTarget() == object) {
            this.setTarget(null);
            if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT || this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
        }
        if (this.getAttackTarget() == object) {
            this.setAttackTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this.getCastTarget() == object) {
            this.setCastTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this.getFollowTarget() == object) {
            this.clientStopMoving(null);
            this.stopFollow();
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._actor == object) {
            this.setTarget(null);
            this.setAttackTarget(null);
            this.setCastTarget(null);
            this.stopFollow();
            this.clientStopMoving(null);
            this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        }
    }

    @Override
    protected void onEvtCancel() {
        this._actor.abortCast();
        this.stopFollow();
        if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        }
        this.onEvtThink();
    }

    @Override
    protected void onEvtDead() {
        this.stopAITask();
        this.clientNotifyDead();
        if (!(this._actor instanceof L2Playable)) {
            this._actor.setWalking();
        }
    }

    @Override
    protected void onEvtFakeDeath() {
        this.stopFollow();
        this.clientStopMoving(null);
        this._intention = CtrlIntention.AI_INTENTION_IDLE;
        this.setTarget(null);
        this.setCastTarget(null);
        this.setAttackTarget(null);
    }

    @Override
    protected void onEvtFinishCasting() {
    }

    @Override
    protected void onEvtAfraid(L2Character effector, boolean start) {
        double radians = Math.toRadians(start ? Util.calculateAngleFrom(effector, this._actor) : Util.convertHeadingToDegree(this._actor.getHeading()));
        int posX = (int)((double)this._actor.getX() + 500.0 * Math.cos(radians));
        int posY = (int)((double)this._actor.getY() + 500.0 * Math.sin(radians));
        int posZ = this._actor.getZ();
        if (!this._actor.isPet()) {
            this._actor.setRunning();
        }
        Location destination = Configuration.geodata().getPathFinding() > 0 ? GeoData.getInstance().moveCheck(this._actor.getX(), this._actor.getY(), this._actor.getZ(), posX, posY, posZ, this._actor.getInstanceId()) : new Location(posX, posY, posZ, this._actor.getInstanceId());
        this.setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, destination);
    }

    protected boolean maybeMoveToPosition(ILocational worldPosition, int offset) {
        if (worldPosition == null) {
            LOG.warn("maybeMoveToPosition: worldPosition == NULL!");
            return false;
        }
        if (offset < 0) {
            return false;
        }
        if (!this._actor.isInsideRadius(worldPosition, offset + this._actor.getTemplate().getCollisionRadius(), false, false)) {
            if (this._actor.isMovementDisabled()) {
                return true;
            }
            if (!(this._actor.isRunning() || this instanceof L2PlayerAI || this instanceof L2SummonAI)) {
                this._actor.setRunning();
            }
            this.stopFollow();
            int x = this._actor.getX();
            int y = this._actor.getY();
            double dx = worldPosition.getX() - x;
            double dy = worldPosition.getY() - y;
            double dist = Math.hypot(dx, dy);
            double sin = dy / dist;
            double cos = dx / dist;
            this.moveTo(x += (int)((dist -= (double)(offset - 5)) * cos), y += (int)(dist * sin), worldPosition.getZ());
            return true;
        }
        if (this.getFollowTarget() != null) {
            this.stopFollow();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean maybeMoveToPawn(L2Object target, int offset) {
        boolean needToMove;
        if (target == null) {
            LOG.warn("maybeMoveToPawn: target == NULL!");
            return false;
        }
        if (offset < 0) {
            return false;
        }
        offset += this._actor.getTemplate().getCollisionRadius();
        if (target instanceof L2Character) {
            L2Character creature = (L2Character)target;
            offset += creature.getTemplate().getCollisionRadius();
        }
        if (target.isDoor()) {
            int n;
            int i;
            L2DoorInstance dor = (L2DoorInstance)target;
            int xPoint = 0;
            int yPoint = 0;
            int[] nArray = dor.getTemplate().getNodeX();
            int n2 = nArray.length;
            for (n = 0; n < n2; xPoint += i, ++n) {
                i = nArray[n];
            }
            nArray = dor.getTemplate().getNodeY();
            n2 = nArray.length;
            for (n = 0; n < n2; yPoint += i, ++n) {
                i = nArray[n];
            }
            needToMove = !this._actor.isInsideRadius(xPoint /= 4, yPoint /= 4, dor.getTemplate().getNodeZ(), offset, false, false);
        } else {
            boolean bl = needToMove = !this._actor.isInsideRadius(target, offset, false, false);
        }
        if (!needToMove) {
            if (this.getFollowTarget() == null) return false;
            this.stopFollow();
            return false;
        }
        if (this.getFollowTarget() != null) {
            if (!this._actor.isInsideRadius(target, offset + 100, false, false)) {
                return true;
            }
            this.stopFollow();
            return false;
        }
        if (this._actor.isMovementDisabled()) {
            if (this._actor.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK) return true;
            this._actor.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            return true;
        }
        if (this._actor.getAI().getIntention() == CtrlIntention.AI_INTENTION_CAST && this._actor instanceof L2PcInstance && this._actor.isTransformed() && !this._actor.getTransformation().isCombat()) {
            this._actor.sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
            this._actor.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        if (!(this._actor.isRunning() || this instanceof L2PlayerAI || this instanceof L2SummonAI)) {
            this._actor.setRunning();
        }
        this.stopFollow();
        if (target instanceof L2Character) {
            L2Character creature = (L2Character)target;
            if (!(target instanceof L2DoorInstance)) {
                if (creature.isMoving()) {
                    offset -= 100;
                }
                if (offset < 5) {
                    offset = 5;
                }
                this.startFollow((L2Character)target, offset);
                return true;
            }
        }
        this.moveToPawn(target, offset);
        return true;
    }

    protected boolean checkTargetLostOrDead(L2Character target) {
        if (target == null || target.isAlikeDead()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isFakeDeath()) {
                target.stopFakeDeath(true);
                return false;
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    protected boolean checkTargetLost(L2Object target) {
        L2PcInstance targetPlayer;
        if (target instanceof L2PcInstance && (targetPlayer = (L2PcInstance)target).isFakeDeath()) {
            targetPlayer.stopFakeDeath(true);
            return false;
        }
        if (target == null) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        if (this._actor != null && this._skill != null && this._skill.isBad() && this._skill.getAffectRange() > 0 && !GeoData.getInstance().canSeeTarget((L2Object)this._actor, target)) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean canAura(Skill sk) {
        return false;
    }

    @Deprecated
    public boolean canAOE(Skill sk) {
        return false;
    }

    public boolean canParty(Skill sk) {
        if (this.isParty(sk)) {
            int count = 0;
            int ccount = 0;
            L2Npc actors = (L2Npc)this._actor;
            for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                if (!(target instanceof L2Attackable)) continue;
                L2Attackable targets = (L2Attackable)target;
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || !targets.isInMyClan(actors)) continue;
                ++count;
                if (!target.isAffectedBySkill(sk.getId())) continue;
                ++ccount;
            }
            if (ccount < count) {
                return true;
            }
        }
        return false;
    }

    public boolean isParty(Skill sk) {
        return sk.getAffectScope() == AffectScope.PARTY;
    }

    public static class CastTask
    implements Runnable {
        private final L2Character _activeChar;
        private final L2Object _target;
        private final Skill _skill;

        public CastTask(L2Character actor, Skill skill, L2Object target) {
            this._activeChar = actor;
            this._target = target;
            this._skill = skill;
        }

        @Override
        public void run() {
            if (this._activeChar.isAttackingNow()) {
                this._activeChar.abortAttack();
            }
            this._activeChar.getAI().changeIntentionToCast(this._skill, this._target);
        }
    }

    protected class TargetAnalysis {
        public L2Character character;
        public boolean isMage;
        public boolean isBalanced;
        public boolean isArcher;
        public boolean isFighter;
        public boolean isCanceled;
        public boolean isSlower;
        public boolean isMagicResistant;

        public void update(L2Character target) {
            if (target == this.character && Rnd.nextInt((int)100) > 25) {
                return;
            }
            this.character = target;
            if (target == null) {
                return;
            }
            this.isMage = false;
            this.isBalanced = false;
            this.isArcher = false;
            this.isFighter = false;
            this.isCanceled = false;
            if (target.getMAtk(null, null) > 1.5 * target.getPAtk(null)) {
                this.isMage = true;
            } else if (target.getPAtk(null) * 0.8 < target.getMAtk(null, null) || target.getMAtk(null, null) * 0.8 > target.getPAtk(null)) {
                this.isBalanced = true;
            } else {
                L2Weapon weapon = target.getActiveWeaponItem();
                if (weapon != null && (weapon.getItemType() == WeaponType.BOW || weapon.getItemType() == WeaponType.CROSSBOW)) {
                    this.isArcher = true;
                } else {
                    this.isFighter = true;
                }
            }
            this.isSlower = target.getRunSpeed() < L2CharacterAI.this._actor.getRunSpeed() - 3.0;
            boolean bl = this.isMagicResistant = target.getMDef(null, null) * 1.2 > L2CharacterAI.this._actor.getMAtk(null, null);
            if (target.getBuffCount() < 4) {
                this.isCanceled = true;
            }
        }
    }

    protected class SelfAnalysis {
        public boolean isMage = false;
        public boolean isBalanced;
        public boolean isArcher = false;
        public boolean isHealer = false;
        public boolean isFighter = false;
        public boolean cannotMoveOnLand = false;
        public List<Skill> generalSkills = new ArrayList<Skill>();
        public List<Skill> buffSkills = new ArrayList<Skill>();
        public List<Skill> debuffSkills = new ArrayList<Skill>();
        public int lastDebuffTick = 0;
        public List<Skill> cancelSkills = new ArrayList<Skill>();
        public List<Skill> healSkills = new ArrayList<Skill>();
        public List<Skill> generalDisablers = new ArrayList<Skill>();
        public List<Skill> sleepSkills = new ArrayList<Skill>();
        public List<Skill> rootSkills = new ArrayList<Skill>();
        public List<Skill> muteSkills = new ArrayList<Skill>();
        public List<Skill> resurrectSkills = new ArrayList<Skill>();
        public boolean hasHealOrResurrect = false;
        public boolean hasLongRangeSkills = false;
        public boolean hasLongRangeDamageSkills = false;
        public int maxCastRange = 0;

        public void init() {
            switch (((L2NpcTemplate)L2CharacterAI.this._actor.getTemplate()).getAIType()) {
                case MAGE: {
                    this.isMage = true;
                    break;
                }
                case CORPSE: 
                case BALANCED: {
                    this.isBalanced = true;
                    break;
                }
                case ARCHER: {
                    this.isArcher = true;
                    break;
                }
                case HEALER: {
                    this.isHealer = true;
                    break;
                }
                default: {
                    this.isFighter = true;
                }
            }
            if (L2CharacterAI.this._actor.isNpc()) {
                switch (L2CharacterAI.this._actor.getId()) {
                    case 20314: 
                    case 20849: {
                        this.cannotMoveOnLand = true;
                        break;
                    }
                    default: {
                        this.cannotMoveOnLand = false;
                    }
                }
            }
            for (Skill sk : L2CharacterAI.this._actor.getAllSkills()) {
                if (sk.isPassive()) continue;
                int castRange = sk.getCastRange();
                boolean hasLongRangeDamageSkill = false;
                if (sk.isContinuous()) {
                    if (!sk.isDebuff()) {
                        this.buffSkills.add(sk);
                        continue;
                    }
                    this.debuffSkills.add(sk);
                    continue;
                }
                if (sk.hasEffectType(L2EffectType.DISPEL, new L2EffectType[0])) {
                    this.cancelSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.HP, new L2EffectType[0])) {
                    this.healSkills.add(sk);
                    this.hasHealOrResurrect = true;
                } else if (sk.hasEffectType(L2EffectType.SLEEP, new L2EffectType[0])) {
                    this.sleepSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.STUN, new L2EffectType[0])) {
                    switch (sk.getId()) {
                        case 367: 
                        case 4111: 
                        case 4383: 
                        case 4578: 
                        case 4616: {
                            this.sleepSkills.add(sk);
                            break;
                        }
                        default: {
                            this.generalDisablers.add(sk);
                            break;
                        }
                    }
                } else if (sk.hasEffectType(L2EffectType.ROOT, new L2EffectType[0])) {
                    this.rootSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.FEAR, new L2EffectType[0])) {
                    this.debuffSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.MUTE, new L2EffectType[0])) {
                    this.muteSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.RESURRECTION, new L2EffectType[0])) {
                    this.resurrectSkills.add(sk);
                    this.hasHealOrResurrect = true;
                } else {
                    this.generalSkills.add(sk);
                    hasLongRangeDamageSkill = true;
                }
                if (castRange > 70) {
                    this.hasLongRangeSkills = true;
                    if (hasLongRangeDamageSkill) {
                        this.hasLongRangeDamageSkills = true;
                    }
                }
                if (castRange <= this.maxCastRange) continue;
                this.maxCastRange = castRange;
            }
            if (!this.hasLongRangeDamageSkills && this.isMage) {
                this.isBalanced = true;
                this.isMage = false;
                this.isFighter = false;
            }
            if (!this.hasLongRangeSkills && (this.isMage || this.isBalanced)) {
                this.isBalanced = false;
                this.isMage = false;
                this.isFighter = true;
            }
            if (this.generalSkills.isEmpty() && this.isMage) {
                this.isBalanced = true;
                this.isMage = false;
            }
        }
    }

    public static class IntentionCommand {
        protected final CtrlIntention _crtlIntention;
        protected final Object _arg0;
        protected final Object _arg1;

        protected IntentionCommand(CtrlIntention pIntention, Object pArg0, Object pArg1) {
            this._crtlIntention = pIntention;
            this._arg0 = pArg0;
            this._arg1 = pArg1;
        }

        public CtrlIntention getCtrlIntention() {
            return this._crtlIntention;
        }
    }
}

