/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.bbs.service;

import com.l2jserver.gameserver.bbs.model.Forum;
import com.l2jserver.gameserver.bbs.model.ForumType;
import com.l2jserver.gameserver.bbs.model.ForumVisibility;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.dao.factory.impl.DAOFactory;
import com.l2jserver.gameserver.model.L2Clan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForumsBBSManager {
    private static final Logger LOG = LoggerFactory.getLogger(ForumsBBSManager.class);
    private static final Map<String, Forum> FORUMS_BY_NAME = new ConcurrentHashMap<String, Forum>();
    private static final Map<Integer, Forum> FORUMS_BY_ID = new ConcurrentHashMap<Integer, Forum>();

    protected ForumsBBSManager() {
    }

    public void load() {
        FORUMS_BY_NAME.putAll(DAOFactory.getInstance().getForumRepository().getForums());
        FORUMS_BY_ID.putAll(FORUMS_BY_NAME.values().stream().collect(Collectors.toMap(Forum::getId, f -> f)));
        LOG.info("Loaded {} forums.", (Object)FORUMS_BY_NAME.size());
    }

    public Forum getForumByName(String name) {
        return FORUMS_BY_NAME.get(name);
    }

    public Forum getForumById(Integer id) {
        return FORUMS_BY_ID.get(id);
    }

    public Forum create(String name, Forum parent, ForumType type, ForumVisibility visibility, int ownerId) {
        Forum forum = new Forum(0, name, parent, type, visibility, ownerId);
        parent.addChild(forum);
        DAOFactory.getInstance().getForumRepository().save(forum);
        FORUMS_BY_NAME.put(forum.getName(), forum);
        FORUMS_BY_ID.put(forum.getId(), forum);
        return forum;
    }

    public Forum load(int id, String name, Forum parent, ForumType type, ForumVisibility visibility, int ownerId) {
        Forum forum = new Forum(id, name, parent, type, visibility, ownerId);
        parent.addChild(forum);
        FORUMS_BY_NAME.put(forum.getName(), forum);
        FORUMS_BY_ID.put(forum.getId(), forum);
        return forum;
    }

    public void onClanLevel(L2Clan clan) {
        Forum forum;
        Forum clanRootForum;
        if (clan.getLevel() >= 2 && Configuration.general().enableCommunityBoard() && (clanRootForum = ForumsBBSManager.getInstance().getForumByName("ClanRoot")) != null && (forum = clanRootForum.getChildByName(clan.getName())) == null) {
            ForumsBBSManager.getInstance().create(clan.getName(), clanRootForum, ForumType.CLAN, ForumVisibility.CLAN_MEMBER_ONLY, clan.getId());
        }
    }

    public static ForumsBBSManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ForumsBBSManager INSTANCE = new ForumsBBSManager();

        private SingletonHolder() {
        }
    }
}

