/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.cache;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.util.file.filter.HTMLFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmCache {
    private static final Logger LOG = LoggerFactory.getLogger(HtmCache.class);
    private static final HTMLFilter HTML_FILTER = new HTMLFilter();
    private static final Map<String, String> HTML_CACHE = Configuration.general().lazyCache() ? new ConcurrentHashMap() : new HashMap();
    private int _loadedFiles;
    private long _bytesBuffLen;

    protected HtmCache() {
        this.reload();
    }

    public void reload() {
        this.reload(Configuration.server().getDatapackRoot());
    }

    public void reload(File f) {
        if (!Configuration.general().lazyCache()) {
            LOG.info("Html cache start...");
            this.parseDir(f);
            LOG.info(String.format("%.3f", this.getMemoryUsage()) + " megabytes on " + this.getLoadedFiles() + " files loaded.");
        } else {
            HTML_CACHE.clear();
            this._loadedFiles = 0;
            this._bytesBuffLen = 0L;
            LOG.info("Running lazy cache.");
        }
    }

    public void reloadPath(File f) {
        this.parseDir(f);
        LOG.info("Reloaded specified path.");
    }

    public double getMemoryUsage() {
        return (float)this._bytesBuffLen / 1048576.0f;
    }

    public int getLoadedFiles() {
        return this._loadedFiles;
    }

    private void parseDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) {
                    this.loadFile(file);
                    continue;
                }
                this.parseDir(file);
            }
        }
    }

    public String loadFile(File file) {
        if (!HTML_FILTER.accept(file)) {
            return null;
        }
        String content = null;
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            int bytes = bis.available();
            byte[] raw = new byte[bytes];
            bis.read(raw);
            content = new String(raw, StandardCharsets.UTF_8);
            content = content.replaceAll("(?s)<!--.*?-->", "");
            String oldContent = HTML_CACHE.put(file.getCanonicalPath(), content);
            if (oldContent == null) {
                this._bytesBuffLen += (long)bytes;
                ++this._loadedFiles;
            } else {
                this._bytesBuffLen = this._bytesBuffLen - (long)oldContent.length() + (long)bytes;
            }
        }
        catch (Exception e) {
            LOG.warn("Problem with htm file {}!", (Object)file, (Object)e);
        }
        return content;
    }

    public String getHtm(String prefix, String path) {
        String newPath = Objects.requireNonNullElse(prefix, "") + path;
        String content = HTML_CACHE.get(newPath);
        if (Configuration.general().lazyCache() && content == null) {
            content = this.loadFile(new File(Configuration.server().getDatapackRoot(), newPath));
            if (content == null) {
                content = this.loadFile(new File(Configuration.server().getScriptRoot(), newPath));
            }
            if (prefix != null && content == null && (content = this.loadFile(new File(Configuration.server().getDatapackRoot(), path))) == null) {
                content = this.loadFile(new File(Configuration.server().getScriptRoot(), path));
            }
        }
        return content;
    }

    public boolean contains(String path) {
        return HTML_CACHE.containsKey(path);
    }

    public boolean isLoadable(String path) {
        return HTML_FILTER.accept(new File(Configuration.server().getDatapackRoot(), path));
    }

    public static HtmCache getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final HtmCache INSTANCE = new HtmCache();

        private SingletonHolder() {
        }
    }
}

