/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.config;

import com.l2jserver.gameserver.config.converter.ItemHolderConverter;
import com.l2jserver.gameserver.config.converter.LocationConverter;
import com.l2jserver.gameserver.config.converter.Seconds2MillisecondsConverter;
import com.l2jserver.gameserver.config.converter.SkillHolderConverter;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Reloadable;

@Config.Sources(value={"file:${L2J_HOME}/custom/game/config/tvt.properties", "file:./config/tvt.properties", "classpath:config/tvt.properties"})
@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.HotReload(value=20L, unit=TimeUnit.MINUTES, type=Config.HotReloadType.ASYNC)
public interface TvTConfiguration
extends Reloadable {
    @Config.Key(value="Enabled")
    public boolean enabled();

    @Config.Key(value="Instanced")
    public boolean instanced();

    @Config.Key(value="InstanceFile")
    public String getInstanceFile();

    @Config.Key(value="Interval")
    public List<String> getInterval();

    @Config.Key(value="ParticipationTime")
    public int getParticipationTime();

    @Config.Key(value="RunningTime")
    public int getRunningTime();

    @Config.Key(value="ParticipationNpcId")
    public int getParticipationNpcId();

    @Config.Key(value="ParticipationFee")
    @Config.ConverterClass(value=ItemHolderConverter.class)
    public ItemHolder getParticipationFee();

    @Config.Key(value="ParticipationNpcLoc")
    @Config.ConverterClass(value=LocationConverter.class)
    public Location getParticipationNpcLoc();

    @Config.Key(value="MinPlayersInTeams")
    public int getMinPlayersInTeams();

    @Config.Key(value="MaxPlayersInTeams")
    public int getMaxPlayersInTeams();

    @Config.Key(value="MinPlayerLevel")
    public int getMinPlayerLevel();

    @Config.Key(value="MaxPlayerLevel")
    public int getMaxPlayerLevel();

    @Config.Key(value="RespawnTeleportDelay")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getRespawnTeleportDelay();

    @Config.Key(value="StartLeaveTeleportDelay")
    @Config.ConverterClass(value=Seconds2MillisecondsConverter.class)
    public long getStartLeaveTeleportDelay();

    @Config.Key(value="Team1Name")
    public String getTeam1Name();

    @Config.Key(value="Team1Loc")
    @Config.ConverterClass(value=LocationConverter.class)
    public Location getTeam1Loc();

    @Config.Key(value="Team2Name")
    public String getTeam2Name();

    @Config.Key(value="Team2Loc")
    @Config.ConverterClass(value=LocationConverter.class)
    public Location getTeam2Loc();

    @Config.Separator(value=";")
    @Config.Key(value="Reward")
    @Config.ConverterClass(value=ItemHolderConverter.class)
    public List<ItemHolder> getReward();

    @Config.Key(value="AllowTargetTeamMember")
    public boolean allowTargetTeamMember();

    @Config.Key(value="AllowScroll")
    public boolean allowScroll();

    @Config.Key(value="AllowPotion")
    public boolean allowPotion();

    @Config.Key(value="AllowSummonByItem")
    public boolean allowSummonByItem();

    @Config.Key(value="DoorsToOpen")
    public List<Integer> getDoorsToOpen();

    @Config.Key(value="DoorsToClose")
    public List<Integer> getDoorsToClose();

    @Config.Key(value="RewardTeamTie")
    public boolean rewardTeamTie();

    @Config.Key(value="EffectsRemoval")
    public int getEffectsRemoval();

    @Config.Separator(value=";")
    @Config.Key(value="FighterBuffs")
    @Config.ConverterClass(value=SkillHolderConverter.class)
    public List<SkillHolder> getFighterBuffs();

    @Config.Separator(value=";")
    @Config.Key(value="MageBuffs")
    @Config.ConverterClass(value=SkillHolderConverter.class)
    public List<SkillHolder> getMageBuffs();

    @Config.Key(value="MaxParticipantsPerIP")
    public int getMaxParticipantsPerIP();

    @Config.Key(value="AllowVoicedInfoCommand")
    public boolean allowVoicedInfoCommand();
}

