/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.json;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.l2jserver.gameserver.config.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExperienceData {
    private static final Logger LOG = LoggerFactory.getLogger(ExperienceData.class);
    private static final Gson GSON = new Gson();
    private static final Type TYPE_MAP_INTEGER_LONG = new TypeToken<Map<Integer, Long>>(){}.getType();
    private final Map<Integer, Long> _expTable = new HashMap<Integer, Long>();

    ExperienceData() {
        this.load();
    }

    public void load() {
        this._expTable.clear();
        try (JsonReader reader = new JsonReader((Reader)new FileReader(new File(Configuration.server().getDatapackRoot(), "data/stats/expData.json")));){
            this._expTable.putAll((Map)GSON.fromJson(reader, TYPE_MAP_INTEGER_LONG));
        }
        catch (FileNotFoundException ex) {
            LOG.warn("data/stats/expData.json not found!", ex);
        }
        catch (IOException ex) {
            LOG.warn("Failed to load expData.json for: ", ex);
        }
    }

    public long getExpForLevel(int level) {
        return this._expTable.get(level);
    }

    public float getPercentFromCurrentLevel(long exp, int level) {
        long expPerLevel = this.getExpForLevel(level);
        long expPerLevel2 = this.getExpForLevel(level + 1);
        return (float)(exp - expPerLevel) / (float)(expPerLevel2 - expPerLevel);
    }

    public static ExperienceData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        static final ExperienceData _instance = new ExperienceData();

        private SingletonHolder() {
        }
    }
}

