/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcBufferTable {
    private static final Logger LOG = LoggerFactory.getLogger(NpcBufferTable.class);
    private final Map<Integer, NpcBufferSkills> _buffers = new HashMap<Integer, NpcBufferSkills>();

    protected NpcBufferTable() {
        int buffGroup;
        int skillFeeAmount;
        int skillFeeId;
        int skillLevel;
        int skillId;
        int npcId;
        NpcBufferSkills skills;
        int lastNpcId;
        ResultSet rs;
        Statement st;
        Connection con;
        int skillCount = 0;
        try {
            con = ConnectionFactory.getInstance().getConnection();
            try {
                st = con.createStatement();
                try {
                    rs = st.executeQuery("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `npc_buffer` ORDER BY `npc_id`");
                    try {
                        lastNpcId = 0;
                        skills = null;
                        while (rs.next()) {
                            npcId = rs.getInt("npc_id");
                            skillId = rs.getInt("skill_id");
                            skillLevel = rs.getInt("skill_level");
                            skillFeeId = rs.getInt("skill_fee_id");
                            skillFeeAmount = rs.getInt("skill_fee_amount");
                            buffGroup = rs.getInt("buff_group");
                            if (npcId != lastNpcId) {
                                if (lastNpcId != 0) {
                                    this._buffers.put(lastNpcId, skills);
                                }
                                skills = new NpcBufferSkills();
                                skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                            } else if (skills != null) {
                                skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                            }
                            lastNpcId = npcId;
                            ++skillCount;
                        }
                        if (lastNpcId != 0) {
                            this._buffers.put(lastNpcId, skills);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error reading npc_buffer table!", ex);
        }
        if (Configuration.general().customNpcBufferTables()) {
            try {
                con = ConnectionFactory.getInstance().getConnection();
                try {
                    st = con.createStatement();
                    try {
                        rs = st.executeQuery("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `custom_npc_buffer` ORDER BY `npc_id`");
                        try {
                            lastNpcId = 0;
                            skills = null;
                            while (rs.next()) {
                                npcId = rs.getInt("npc_id");
                                skillId = rs.getInt("skill_id");
                                skillLevel = rs.getInt("skill_level");
                                skillFeeId = rs.getInt("skill_fee_id");
                                skillFeeAmount = rs.getInt("skill_fee_amount");
                                buffGroup = rs.getInt("buff_group");
                                if (npcId != lastNpcId) {
                                    if (lastNpcId != 0) {
                                        this._buffers.put(lastNpcId, skills);
                                    }
                                    skills = new NpcBufferSkills();
                                    skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                                } else if (skills != null) {
                                    skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                                }
                                lastNpcId = npcId;
                                ++skillCount;
                            }
                            if (lastNpcId != 0) {
                                this._buffers.put(lastNpcId, skills);
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (st != null) {
                            st.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("There has been an error reading custom_npc_buffer table!", ex);
            }
        }
        LOG.info("Loaded {} buffers and {} skills.", (Object)this._buffers.size(), (Object)skillCount);
    }

    public NpcBufferData getSkillInfo(int npcId, int buffGroup) {
        NpcBufferSkills skills = this._buffers.get(npcId);
        if (skills != null) {
            return skills.getSkillGroupInfo(buffGroup);
        }
        return null;
    }

    public static NpcBufferTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class NpcBufferSkills {
        private final Map<Integer, NpcBufferData> _skills = new HashMap<Integer, NpcBufferData>();

        private NpcBufferSkills() {
        }

        public void addSkill(int skillId, int skillLevel, int skillFeeId, int skillFeeAmount, int buffGroup) {
            this._skills.put(buffGroup, new NpcBufferData(skillId, skillLevel, skillFeeId, skillFeeAmount));
        }

        public NpcBufferData getSkillGroupInfo(int buffGroup) {
            return this._skills.get(buffGroup);
        }
    }

    public static class NpcBufferData {
        private final SkillHolder _skill;
        private final ItemHolder _fee;

        protected NpcBufferData(int skillId, int skillLevel, int feeId, int feeAmount) {
            this._skill = new SkillHolder(skillId, skillLevel);
            this._fee = new ItemHolder(feeId, feeAmount);
        }

        public SkillHolder getSkill() {
            return this._skill;
        }

        public ItemHolder getFee() {
            return this._fee;
        }
    }

    private static class SingletonHolder {
        protected static final NpcBufferTable _instance = new NpcBufferTable();

        private SingletonHolder() {
        }
    }
}

