/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ArmorSetsData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(ArmorSetsData.class);
    private final Map<Integer, L2ArmorSet> _armorSets = new HashMap<Integer, L2ArmorSet>();

    protected ArmorSetsData() {
        this.load();
    }

    @Override
    public void load() {
        this._armorSets.clear();
        this.parseDatapackDirectory("data/stats/armorsets", false);
        LOG.info("Loaded {} armor sets.", (Object)this._armorSets.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"set".equalsIgnoreCase(d.getNodeName())) continue;
                L2ArmorSet set = new L2ArmorSet();
                block36: for (Node a = d.getFirstChild(); a != null; a = a.getNextSibling()) {
                    NamedNodeMap attrs = a.getAttributes();
                    switch (a.getNodeName()) {
                        case "chest": {
                            set.addChest(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "feet": {
                            set.addFeet(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "gloves": {
                            set.addGloves(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "head": {
                            set.addHead(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "legs": {
                            set.addLegs(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "shield": {
                            set.addShield(this.parseInteger(attrs, "id"));
                            continue block36;
                        }
                        case "skill": {
                            set.addSkill(new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "level")));
                            continue block36;
                        }
                        case "shield_skill": {
                            set.addShieldSkill(new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "level")));
                            continue block36;
                        }
                        case "enchant6skill": {
                            set.addEnchant6Skill(new SkillHolder(this.parseInteger(attrs, "id"), this.parseInteger(attrs, "level")));
                            continue block36;
                        }
                        case "con": {
                            set.addCon(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "dex": {
                            set.addDex(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "str": {
                            set.addStr(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "men": {
                            set.addMen(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "wit": {
                            set.addWit(this.parseInteger(attrs, "val"));
                            continue block36;
                        }
                        case "int": {
                            set.addInt(this.parseInteger(attrs, "val"));
                        }
                    }
                }
                this._armorSets.put(set.getChestId(), set);
            }
        }
    }

    public boolean isArmorSet(int chestId) {
        return this._armorSets.containsKey(chestId);
    }

    public L2ArmorSet getSet(int chestId) {
        return this._armorSets.get(chestId);
    }

    public static ArmorSetsData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final ArmorSetsData INSTANCE = new ArmorSetsData();

        private SingletonHolder() {
        }
    }
}

