/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CategoryData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryData.class);
    private final Map<CategoryType, Set<Integer>> _categories = new HashMap<CategoryType, Set<Integer>>();

    protected CategoryData() {
        this.load();
    }

    @Override
    public void load() {
        this._categories.clear();
        this.parseDatapackFile("data/categoryData.xml");
        LOG.info("Loaded {} Categories.", (Object)this._categories.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
            for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                if (!"category".equalsIgnoreCase(list_node.getNodeName())) continue;
                NamedNodeMap attrs = list_node.getAttributes();
                CategoryType categoryType = CategoryType.findByName(attrs.getNamedItem("name").getNodeValue());
                if (categoryType == null) {
                    LOG.warn("Can't find category by name :{}", (Object)attrs.getNamedItem("name").getNodeValue());
                    continue;
                }
                HashSet<Integer> ids = new HashSet<Integer>();
                for (Node category_node = list_node.getFirstChild(); category_node != null; category_node = category_node.getNextSibling()) {
                    if (!"id".equalsIgnoreCase(category_node.getNodeName())) continue;
                    ids.add(Integer.parseInt(category_node.getTextContent()));
                }
                this._categories.put(categoryType, ids);
            }
        }
    }

    public boolean isInCategory(CategoryType type, ClassId classId) {
        return this.isInCategory(type, classId.getId());
    }

    public boolean isInCategory(CategoryType type, int id) {
        Set<Integer> category = this.getCategoryByType(type);
        if (category == null) {
            LOG.warn("Can not find category type {}!", (Object)type);
            return false;
        }
        return category.contains(id);
    }

    public Set<Integer> getCategoryByType(CategoryType type) {
        return this._categories.get((Object)type);
    }

    public static CategoryData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final CategoryData INSTANCE = new CategoryData();

        private SingletonHolder() {
        }
    }
}

