/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.templates.L2DoorTemplate;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DoorData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(DoorData.class);
    private static final Map<String, Set<Integer>> GROUPS = new HashMap<String, Set<Integer>>();
    private final Map<Integer, L2DoorInstance> _doors = new HashMap<Integer, L2DoorInstance>();
    private final Map<Integer, StatsSet> _templates = new HashMap<Integer, StatsSet>();
    private final Map<Integer, List<L2DoorInstance>> _regions = new HashMap<Integer, List<L2DoorInstance>>();

    protected DoorData() {
        this.load();
    }

    @Override
    public void load() {
        this._doors.clear();
        GROUPS.clear();
        this._regions.clear();
        this.parseDatapackFile("data/doors.xml");
        LOG.info("Loaded {} door templates for {} regions.", (Object)this._doors.size(), (Object)this._regions.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node a = doc.getFirstChild(); a != null; a = a.getNextSibling()) {
            if (!"list".equalsIgnoreCase(a.getNodeName())) continue;
            for (Node b = a.getFirstChild(); b != null; b = b.getNextSibling()) {
                if (!"door".equalsIgnoreCase(b.getNodeName())) continue;
                NamedNodeMap attrs = b.getAttributes();
                StatsSet set = new StatsSet();
                set.set("baseHpMax", 1);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                this.makeDoor(set);
                this._templates.put(set.getInt("id"), set);
            }
        }
    }

    public void insertCollisionData(StatsSet set) {
        int height = set.getInt("height");
        String[] pos = set.getString("node1").split(",");
        int nodeX = Integer.parseInt(pos[0]);
        int nodeY = Integer.parseInt(pos[1]);
        pos = set.getString("node2").split(",");
        int posX = Integer.parseInt(pos[0]);
        int posY = Integer.parseInt(pos[1]);
        int collisionRadius = Math.min(Math.abs(nodeX - posX), Math.abs(nodeY - posY));
        if (collisionRadius < 20) {
            collisionRadius = 20;
        }
        set.set("collisionRadius", collisionRadius);
        set.set("collisionHeight", height);
    }

    private void makeDoor(StatsSet set) {
        this.insertCollisionData(set);
        int objectId = IdFactory.getInstance().getNextId();
        L2DoorTemplate template = new L2DoorTemplate(set);
        L2DoorInstance door = new L2DoorInstance(objectId, template);
        door.setCurrentHp(door.getMaxHp());
        door.spawnMe(template.getX(), template.getY(), template.getZ());
        this.putDoor(door, MapRegionManager.getInstance().getMapRegionLocId(door));
    }

    public StatsSet getDoorTemplate(int doorId) {
        return this._templates.get(doorId);
    }

    public L2DoorInstance getDoor(int doorId) {
        return this._doors.get(doorId);
    }

    public void putDoor(L2DoorInstance door, int region) {
        this._doors.put(door.getId(), door);
        if (!this._regions.containsKey(region)) {
            this._regions.put(region, new ArrayList());
        }
        this._regions.get(region).add(door);
    }

    public static void addDoorGroup(String groupName, int doorId) {
        GROUPS.computeIfAbsent(groupName, k -> new HashSet()).add(doorId);
    }

    public static Set<Integer> getDoorsByGroup(String groupName) {
        return GROUPS.get(groupName);
    }

    public Collection<L2DoorInstance> getDoors() {
        return this._doors.values();
    }

    public boolean checkIfDoorsBetween(AbstractNodeLoc start, AbstractNodeLoc end, int instanceId) {
        return this.checkIfDoorsBetween(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), instanceId);
    }

    public boolean checkIfDoorsBetween(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        return this.checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId, false);
    }

    public boolean checkIfDoorsBetween(int x, int y, int z, int tx, int ty, int tz, int instanceId, boolean doubleFaceCheck) {
        Collection allDoors = instanceId > 0 && InstanceManager.getInstance().getInstance(instanceId) != null ? InstanceManager.getInstance().getInstance(instanceId).getDoors() : (Collection)this._regions.get(MapRegionManager.getInstance().getMapRegionLocId(x, y));
        if (allDoors == null) {
            return false;
        }
        for (L2DoorInstance doorInst : allDoors) {
            if (doorInst.isDead() || doorInst.getOpen() || !doorInst.checkCollision() || doorInst.getX(0) == 0) continue;
            boolean intersectFace = false;
            for (int i = 0; i < 4; ++i) {
                int intersectZ;
                int j = i + 1 < 4 ? i + 1 : 0;
                int denominator = (ty - y) * (doorInst.getX(i) - doorInst.getX(j)) - (tx - x) * (doorInst.getY(i) - doorInst.getY(j));
                if (denominator == 0) continue;
                float multiplier1 = (float)((doorInst.getX(j) - doorInst.getX(i)) * (y - doorInst.getY(i)) - (doorInst.getY(j) - doorInst.getY(i)) * (x - doorInst.getX(i))) / (float)denominator;
                float multiplier2 = (float)((tx - x) * (y - doorInst.getY(i)) - (ty - y) * (x - doorInst.getX(i))) / (float)denominator;
                if (!(multiplier1 >= 0.0f) || !(multiplier1 <= 1.0f) || !(multiplier2 >= 0.0f) || !(multiplier2 <= 1.0f) || (intersectZ = Math.round((float)z + multiplier1 * (float)(tz - z))) <= doorInst.getZMin() || intersectZ >= doorInst.getZMax()) continue;
                if (!doubleFaceCheck || intersectFace) {
                    return true;
                }
                intersectFace = true;
            }
        }
        return false;
    }

    public static DoorData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final DoorData INSTANCE = new DoorData();

        private SingletonHolder() {
        }
    }
}

