/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.holders.RangeChanceHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.enchant.EnchantItemGroup;
import com.l2jserver.gameserver.model.items.enchant.EnchantRateItem;
import com.l2jserver.gameserver.model.items.enchant.EnchantScrollGroup;
import com.l2jserver.gameserver.util.IXmlReader;
import com.l2jserver.gameserver.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class EnchantItemGroupsData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(EnchantItemGroupsData.class);
    private final Map<String, EnchantItemGroup> _itemGroups = new HashMap<String, EnchantItemGroup>();
    private final Map<Integer, EnchantScrollGroup> _scrollGroups = new HashMap<Integer, EnchantScrollGroup>();

    protected EnchantItemGroupsData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._itemGroups.clear();
        this._scrollGroups.clear();
        this.parseDatapackFile("data/enchantItemGroups.xml");
        LOG.info("Loaded {} item group templates.", (Object)this._itemGroups.size());
        LOG.info("Loaded {} scroll group templates.", (Object)this._scrollGroups.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                Node cd;
                Object group;
                if ("enchantRateGroup".equalsIgnoreCase(d.getNodeName())) {
                    String name = this.parseString(d.getAttributes(), "name");
                    group = new EnchantItemGroup(name);
                    for (cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                        if (!"current".equalsIgnoreCase(cd.getNodeName())) continue;
                        String range = this.parseString(cd.getAttributes(), "enchant");
                        double chance = this.parseDouble(cd.getAttributes(), "chance");
                        int min = -1;
                        int max = 0;
                        if (range.contains("-")) {
                            String[] split = range.split("-");
                            if (split.length == 2 && Util.isDigit(split[0]) && Util.isDigit(split[1])) {
                                min = Integer.parseInt(split[0]);
                                max = Integer.parseInt(split[1]);
                            }
                        } else if (Util.isDigit(range)) {
                            max = min = Integer.parseInt(range);
                        }
                        if (min <= -1 || max <= 0) continue;
                        ((EnchantItemGroup)group).addChance(new RangeChanceHolder(min, max, chance));
                    }
                    this._itemGroups.put(name, (EnchantItemGroup)group);
                    continue;
                }
                if (!"enchantScrollGroup".equals(d.getNodeName())) continue;
                int id = this.parseInteger(d.getAttributes(), "id");
                group = new EnchantScrollGroup(id);
                for (cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    if (!"enchantRate".equalsIgnoreCase(cd.getNodeName())) continue;
                    EnchantRateItem rateGroup = new EnchantRateItem(this.parseString(cd.getAttributes(), "group"));
                    for (Node z = cd.getFirstChild(); z != null; z = z.getNextSibling()) {
                        if (!"item".equals(z.getNodeName())) continue;
                        NamedNodeMap attrs = z.getAttributes();
                        if (attrs.getNamedItem("slot") != null) {
                            rateGroup.addSlot(ItemTable.SLOTS.get(this.parseString(attrs, "slot")));
                        }
                        if (attrs.getNamedItem("magicWeapon") != null) {
                            rateGroup.setMagicWeapon(this.parseBoolean(attrs, "magicWeapon"));
                        }
                        if (attrs.getNamedItem("id") == null) continue;
                        rateGroup.setItemId(this.parseInteger(attrs, "id"));
                    }
                    ((EnchantScrollGroup)group).addRateGroup(rateGroup);
                }
                this._scrollGroups.put(id, (EnchantScrollGroup)group);
            }
        }
    }

    public EnchantItemGroup getItemGroup(L2Item item, int scrollGroup) {
        EnchantScrollGroup group = this._scrollGroups.get(scrollGroup);
        EnchantRateItem rateGroup = group.getRateGroup(item);
        return rateGroup != null ? this._itemGroups.get(rateGroup.getName()) : null;
    }

    public EnchantItemGroup getItemGroup(String name) {
        return this._itemGroups.get(name);
    }

    public EnchantScrollGroup getScrollGroup(int id) {
        return this._scrollGroups.get(id);
    }

    public static EnchantItemGroupsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemGroupsData _instance = new EnchantItemGroupsData();

        private SingletonHolder() {
        }
    }
}

