/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.util.IXmlReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class HitConditionBonusData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(HitConditionBonusData.class);
    private int frontBonus = 0;
    private int sideBonus = 0;
    private int backBonus = 0;
    private int highBonus = 0;
    private int lowBonus = 0;
    private int darkBonus = 0;
    private int rainBonus = 0;

    protected HitConditionBonusData() {
        this.load();
    }

    @Override
    public void load() {
        this.parseDatapackFile("data/stats/hitConditionBonus.xml");
        LOG.info("Loaded Hit Condition bonuses.");
        LOG.debug("Front bonus {}.", (Object)this.frontBonus);
        LOG.debug("Side bonus {}.", (Object)this.sideBonus);
        LOG.debug("Back bonus {}.", (Object)this.backBonus);
        LOG.debug("High bonus {}.", (Object)this.highBonus);
        LOG.debug("Low bonus {}.", (Object)this.lowBonus);
        LOG.debug("Dark bonus {}.", (Object)this.darkBonus);
        LOG.debug("Rain bonus {}.", (Object)this.rainBonus);
    }

    @Override
    public void parseDocument(Document doc) {
        block18: for (Node d = doc.getFirstChild().getFirstChild(); d != null; d = d.getNextSibling()) {
            NamedNodeMap attrs = d.getAttributes();
            switch (d.getNodeName()) {
                case "front": {
                    this.frontBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "side": {
                    this.sideBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "back": {
                    this.backBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "high": {
                    this.highBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "low": {
                    this.lowBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "dark": {
                    this.darkBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "rain": {
                    this.rainBonus = this.parseInteger(attrs, "val");
                }
            }
        }
    }

    public double getConditionBonus(L2Character attacker, L2Character target) {
        double mod = 100.0;
        if (attacker.getZ() - target.getZ() > 50) {
            mod += (double)this.highBonus;
        } else if (attacker.getZ() - target.getZ() < -50) {
            mod += (double)this.lowBonus;
        }
        if (GameTimeController.getInstance().isNight()) {
            mod += (double)this.darkBonus;
        }
        mod = attacker.isBehindTarget() ? (mod += (double)this.backBonus) : (attacker.isInFrontOfTarget() ? (mod += (double)this.frontBonus) : (mod += (double)this.sideBonus));
        return Math.max(mod / 100.0, 0.0);
    }

    public static HitConditionBonusData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final HitConditionBonusData INSTANCE = new HitConditionBonusData();

        private SingletonHolder() {
        }
    }
}

