/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.items.PcItemTemplate;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class InitialEquipmentData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(InitialEquipmentData.class);
    private static final String NORMAL = "data/stats/initialEquipment.xml";
    private static final String EVENT = "data/stats/initialEquipmentEvent.xml";
    private final Map<ClassId, List<PcItemTemplate>> _initialEquipmentList = new HashMap<ClassId, List<PcItemTemplate>>();

    protected InitialEquipmentData() {
        this.load();
    }

    @Override
    public void load() {
        this._initialEquipmentList.clear();
        this.parseDatapackFile(Configuration.character().initialEquipmentEvent() ? EVENT : NORMAL);
        LOG.info("Loaded {} initial equipment data.", (Object)this._initialEquipmentList.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"equipment".equalsIgnoreCase(d.getNodeName())) continue;
                this.parseEquipment(d);
            }
        }
    }

    private void parseEquipment(Node d) {
        NamedNodeMap attrs = d.getAttributes();
        ClassId classId = ClassId.getClassId(Integer.parseInt(attrs.getNamedItem("classId").getNodeValue()));
        ArrayList<PcItemTemplate> equipList = new ArrayList<PcItemTemplate>();
        for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!"item".equalsIgnoreCase(c.getNodeName())) continue;
            StatsSet set = new StatsSet();
            attrs = c.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                set.set(attr.getNodeName(), attr.getNodeValue());
            }
            equipList.add(new PcItemTemplate(set));
        }
        this._initialEquipmentList.put(classId, equipList);
    }

    public List<PcItemTemplate> getEquipmentList(ClassId cId) {
        return this._initialEquipmentList.get(cId);
    }

    public List<PcItemTemplate> getEquipmentList(int cId) {
        return this._initialEquipmentList.get(ClassId.getClassId(cId));
    }

    public static InitialEquipmentData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final InitialEquipmentData INSTANCE = new InitialEquipmentData();

        private SingletonHolder() {
        }
    }
}

