/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.options.Options;
import com.l2jserver.gameserver.model.options.OptionsSkillHolder;
import com.l2jserver.gameserver.model.options.OptionsSkillType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.functions.FuncTemplate;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OptionData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(OptionData.class);
    private final Map<Integer, Options> _optionData = new HashMap<Integer, Options>();

    protected OptionData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._optionData.clear();
        this.parseDatapackDirectory("data/stats/options", false);
        LOG.info("Loaded {} item options.", (Object)this._optionData.size());
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"option".equalsIgnoreCase(d.getNodeName())) continue;
                int id = this.parseInteger(d.getAttributes(), "id");
                Options op = new Options(id);
                block31: for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    switch (cd.getNodeName()) {
                        case "for": {
                            for (Node fd = cd.getFirstChild(); fd != null; fd = fd.getNextSibling()) {
                                switch (fd.getNodeName()) {
                                    case "add": 
                                    case "sub": 
                                    case "mul": 
                                    case "div": 
                                    case "set": 
                                    case "share": 
                                    case "enchant": 
                                    case "enchanthp": {
                                        this.parseFuncs(fd.getAttributes(), fd.getNodeName(), op);
                                    }
                                }
                            }
                            continue block31;
                        }
                        case "active_skill": {
                            op.setActiveSkill(new SkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level")));
                            continue block31;
                        }
                        case "passive_skill": {
                            op.setPassiveSkill(new SkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level")));
                            continue block31;
                        }
                        case "attack_skill": {
                            op.addActivationSkill(new OptionsSkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"), this.parseDouble(cd.getAttributes(), "chance"), OptionsSkillType.ATTACK));
                            continue block31;
                        }
                        case "magic_skill": {
                            op.addActivationSkill(new OptionsSkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"), this.parseDouble(cd.getAttributes(), "chance"), OptionsSkillType.MAGIC));
                            continue block31;
                        }
                        case "critical_skill": {
                            op.addActivationSkill(new OptionsSkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"), this.parseDouble(cd.getAttributes(), "chance"), OptionsSkillType.CRITICAL));
                        }
                    }
                }
                this._optionData.put(op.getId(), op);
            }
        }
    }

    private void parseFuncs(NamedNodeMap attrs, String functionName, Options op) {
        Stats stat = Stats.valueOfXml(this.parseString(attrs, "stat"));
        double val = this.parseDouble(attrs, "val");
        int order = -1;
        Node orderNode = attrs.getNamedItem("order");
        if (orderNode != null) {
            order = Integer.parseInt(orderNode.getNodeValue());
        }
        op.addFunc(new FuncTemplate(null, null, functionName, order, stat, val));
    }

    public Options getOptions(int id) {
        return this._optionData.get(id);
    }

    public static OptionData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final OptionData INSTANCE = new OptionData();

        private SingletonHolder() {
        }
    }
}

