/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PlayerCreationPointData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerCreationPointData.class);
    private final Map<ClassId, Location[]> _creationPointData = new HashMap<ClassId, Location[]>();

    protected PlayerCreationPointData() {
        this.load();
    }

    @Override
    public void load() {
        this._creationPointData.clear();
        this.parseDatapackFile("data/stats/chars/pcCreationPoints.xml");
        LOG.info("Loaded {} character creation points.", (Object)this._creationPointData.values().stream().mapToInt(array -> ((Location[])array).length).sum());
    }

    public Location getCreationPoint(ClassId classId) {
        return (Location)Rnd.randomElement((Object[])this._creationPointData.get(classId));
    }

    @Override
    public void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"startpoints".equalsIgnoreCase(d.getNodeName())) continue;
                ArrayList<Location> creationPoints = new ArrayList<Location>();
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if ("spawn".equalsIgnoreCase(c.getNodeName())) {
                        NamedNodeMap attrs = c.getAttributes();
                        creationPoints.add(new Location(this.parseInteger(attrs, "x"), this.parseInteger(attrs, "y"), this.parseInteger(attrs, "z")));
                        continue;
                    }
                    if (!"classid".equalsIgnoreCase(c.getNodeName())) continue;
                    this._creationPointData.put(ClassId.getClassId(Integer.parseInt(c.getTextContent())), creationPoints.toArray(new Location[0]));
                }
            }
        }
    }

    public static PlayerCreationPointData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final PlayerCreationPointData INSTANCE = new PlayerCreationPointData();

        private SingletonHolder() {
        }
    }
}

