/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.xml.impl;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2PcTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.util.IXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class PlayerTemplateData
implements IXmlReader {
    private static final Logger LOG = LoggerFactory.getLogger(PlayerTemplateData.class);
    private final Map<ClassId, L2PcTemplate> _playerTemplates = new HashMap<ClassId, L2PcTemplate>();
    private int _dataCount = 0;

    protected PlayerTemplateData() {
        this.load();
    }

    @Override
    public void load() {
        this._playerTemplates.clear();
        this.parseDatapackDirectory("data/stats/chars/baseStats", false);
        LOG.info("Loaded {} character templates.", (Object)this._playerTemplates.size());
        LOG.info("Loaded {} level up gain records.", (Object)this._dataCount);
    }

    @Override
    public void parseDocument(Document doc) {
        int classId = 0;
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if ("classId".equalsIgnoreCase(d.getNodeName())) {
                    classId = Integer.parseInt(d.getTextContent());
                    continue;
                }
                if ("staticData".equalsIgnoreCase(d.getNodeName())) {
                    StatsSet set = new StatsSet();
                    set.set("classId", classId);
                    for (Node nd = d.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                        if (nd.getNodeName().equals("#text")) continue;
                        if (nd.getChildNodes().getLength() > 1) {
                            for (Node cnd = nd.getFirstChild(); cnd != null; cnd = cnd.getNextSibling()) {
                                if (nd.getNodeName().equalsIgnoreCase("collisionMale")) {
                                    if (cnd.getNodeName().equalsIgnoreCase("radius")) {
                                        set.set("collisionRadius", cnd.getTextContent());
                                    } else if (cnd.getNodeName().equalsIgnoreCase("height")) {
                                        set.set("collisionHeight", cnd.getTextContent());
                                    }
                                }
                                if ("walk".equalsIgnoreCase(cnd.getNodeName())) {
                                    set.set("baseWalkSpd", cnd.getTextContent());
                                    continue;
                                }
                                if ("run".equalsIgnoreCase(cnd.getNodeName())) {
                                    set.set("baseRunSpd", cnd.getTextContent());
                                    continue;
                                }
                                if ("slowSwim".equals(cnd.getNodeName())) {
                                    set.set("baseSwimWalkSpd", cnd.getTextContent());
                                    continue;
                                }
                                if ("fastSwim".equals(cnd.getNodeName())) {
                                    set.set("baseSwimRunSpd", cnd.getTextContent());
                                    continue;
                                }
                                if (cnd.getNodeName().equals("#text")) continue;
                                set.set(nd.getNodeName() + cnd.getNodeName(), cnd.getTextContent());
                            }
                            continue;
                        }
                        set.set(nd.getNodeName(), nd.getTextContent());
                    }
                    set.set("basePDef", set.getInt("basePDefchest", 0) + set.getInt("basePDeflegs", 0) + set.getInt("basePDefhead", 0) + set.getInt("basePDeffeet", 0) + set.getInt("basePDefgloves", 0) + set.getInt("basePDefunderwear", 0) + set.getInt("basePDefcloak", 0));
                    set.set("baseMDef", set.getInt("baseMDefrear", 0) + set.getInt("baseMDeflear", 0) + set.getInt("baseMDefrfinger", 0) + set.getInt("baseMDefrfinger", 0) + set.getInt("baseMDefneck", 0));
                    this._playerTemplates.put(ClassId.getClassId(classId), new L2PcTemplate(set));
                    continue;
                }
                if (!"lvlUpgainData".equalsIgnoreCase(d.getNodeName())) continue;
                for (Node lvlNode = d.getFirstChild(); lvlNode != null; lvlNode = lvlNode.getNextSibling()) {
                    if (!"level".equalsIgnoreCase(lvlNode.getNodeName())) continue;
                    NamedNodeMap attrs = lvlNode.getAttributes();
                    int level = this.parseInteger(attrs, "val");
                    for (Node valNode = lvlNode.getFirstChild(); valNode != null; valNode = valNode.getNextSibling()) {
                        String nodeName = valNode.getNodeName();
                        if (!nodeName.startsWith("hp") && !nodeName.startsWith("mp") && !nodeName.startsWith("cp") || !this._playerTemplates.containsKey(ClassId.getClassId(classId))) continue;
                        this._playerTemplates.get(ClassId.getClassId(classId)).setUpgainValue(nodeName, level, Double.parseDouble(valNode.getTextContent()));
                        ++this._dataCount;
                    }
                }
            }
        }
    }

    public L2PcTemplate getTemplate(ClassId classId) {
        return this._playerTemplates.get(classId);
    }

    public L2PcTemplate getTemplate(int classId) {
        return this._playerTemplates.get(ClassId.getClassId(classId));
    }

    public static PlayerTemplateData getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        protected static final PlayerTemplateData INSTANCE = new PlayerTemplateData();

        private SingletonHolder() {
        }
    }
}

