/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MerchantPriceConfigTable
implements InstanceListManager {
    private static final Logger LOG = LoggerFactory.getLogger(MerchantPriceConfigTable.class);
    private static final String MPCS_FILE = "MerchantPriceConfig.xml";
    private final Map<Integer, MerchantPriceConfig> _mpcs = new HashMap<Integer, MerchantPriceConfig>();
    private MerchantPriceConfig _defaultMpc;

    public static MerchantPriceConfigTable getInstance() {
        return SingletonHolder._instance;
    }

    public MerchantPriceConfig getMerchantPriceConfig(L2MerchantInstance npc) {
        for (MerchantPriceConfig mpc : this._mpcs.values()) {
            if (npc.getWorldRegion() == null || !npc.getWorldRegion().containsZone(mpc.getZoneId())) continue;
            return mpc;
        }
        return this._defaultMpc;
    }

    public MerchantPriceConfig getMerchantPriceConfig(int id) {
        return this._mpcs.get(id);
    }

    public void loadXML() throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Configuration.server().getDatapackRoot(), "data/MerchantPriceConfig.xml");
        if (file.exists()) {
            Document doc = factory.newDocumentBuilder().parse(file);
            Node n = doc.getDocumentElement();
            Node dpcNode = n.getAttributes().getNamedItem("defaultPriceConfig");
            if (dpcNode == null) {
                throw new IllegalStateException("merchantPriceConfig must define an 'defaultPriceConfig'");
            }
            int defaultPriceConfigId = Integer.parseInt(dpcNode.getNodeValue());
            for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
                MerchantPriceConfig mpc = this.parseMerchantPriceConfig(n);
                if (mpc == null) continue;
                this._mpcs.put(mpc.getId(), mpc);
            }
            MerchantPriceConfig defaultMpc = this.getMerchantPriceConfig(defaultPriceConfigId);
            if (defaultMpc == null) {
                throw new IllegalStateException("'defaultPriceConfig' points to an non-loaded priceConfig");
            }
            this._defaultMpc = defaultMpc;
        }
    }

    private MerchantPriceConfig parseMerchantPriceConfig(Node n) {
        if (n.getNodeName().equals("priceConfig")) {
            int castleId = -1;
            int zoneId = -1;
            Node node = n.getAttributes().getNamedItem("id");
            if (node == null) {
                throw new IllegalStateException("Must define the priceConfig 'id'");
            }
            int id = Integer.parseInt(node.getNodeValue());
            node = n.getAttributes().getNamedItem("name");
            if (node == null) {
                throw new IllegalStateException("Must define the priceConfig 'name'");
            }
            String name = node.getNodeValue();
            node = n.getAttributes().getNamedItem("baseTax");
            if (node == null) {
                throw new IllegalStateException("Must define the priceConfig 'baseTax'");
            }
            int baseTax = Integer.parseInt(node.getNodeValue());
            node = n.getAttributes().getNamedItem("castleId");
            if (node != null) {
                castleId = Integer.parseInt(node.getNodeValue());
            }
            if ((node = n.getAttributes().getNamedItem("zoneId")) != null) {
                zoneId = Integer.parseInt(node.getNodeValue());
            }
            return new MerchantPriceConfig(id, name, baseTax, castleId, zoneId);
        }
        return null;
    }

    @Override
    public void loadInstances() {
        try {
            this.loadXML();
            LOG.info("Loaded {} merchant price configs.", (Object)this._mpcs.size());
        }
        catch (Exception ex) {
            LOG.error("Failed loading MerchantPriceConfigTable!", ex);
        }
    }

    @Override
    public void updateReferences() {
        for (MerchantPriceConfig mpc : this._mpcs.values()) {
            mpc.updateReferences();
        }
    }

    @Override
    public void activateInstances() {
    }

    private static class SingletonHolder {
        protected static final MerchantPriceConfigTable _instance = new MerchantPriceConfigTable();

        private SingletonHolder() {
        }
    }

    public static final class MerchantPriceConfig {
        private final int _id;
        private final String _name;
        private final int _baseTax;
        private final int _castleId;
        private Castle _castle;
        private final int _zoneId;

        public MerchantPriceConfig(int id, String name, int baseTax, int castleId, int zoneId) {
            this._id = id;
            this._name = name;
            this._baseTax = baseTax;
            this._castleId = castleId;
            this._zoneId = zoneId;
        }

        public int getId() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        public int getBaseTax() {
            return this._baseTax;
        }

        public double getBaseTaxRate() {
            return (double)this._baseTax / 100.0;
        }

        public Castle getCastle() {
            return this._castle;
        }

        public int getZoneId() {
            return this._zoneId;
        }

        public boolean hasCastle() {
            return this.getCastle() != null;
        }

        public double getCastleTaxRate() {
            return this.hasCastle() ? this.getCastle().getTaxRate() : 0.0;
        }

        public int getTotalTax() {
            return this.hasCastle() ? this.getCastle().getTaxPercent() + this.getBaseTax() : this.getBaseTax();
        }

        public double getTotalTaxRate() {
            return (double)this.getTotalTax() / 100.0;
        }

        public void updateReferences() {
            if (this._castleId > 0) {
                this._castle = CastleManager.getInstance().getCastleById(this._castleId);
            }
        }
    }
}

