/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Couple;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoupleManager {
    private static final Logger LOG = LoggerFactory.getLogger(CoupleManager.class);
    private final List<Couple> _couples = new CopyOnWriteArrayList<Couple>();

    private CoupleManager() {
        this.load();
    }

    public void reload() {
        this._couples.clear();
        this.load();
    }

    private void load() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement ps = con.createStatement();
             ResultSet rs = ps.executeQuery("SELECT id FROM mods_wedding ORDER BY id");){
            while (rs.next()) {
                this.getCouples().add(new Couple(rs.getInt("id")));
            }
            LOG.info("Loaded: {} couples(s)", (Object)this.getCouples().size());
        }
        catch (Exception e) {
            LOG.error("Exception: CoupleManager.load(): {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public Couple getCouple(int coupleId) {
        int index = this.getCoupleIndex(coupleId);
        if (index >= 0) {
            return this.getCouples().get(index);
        }
        return null;
    }

    public void createCouple(L2PcInstance player1, L2PcInstance player2) {
        if (player1 != null && player2 != null && player1.getPartnerId() == 0 && player2.getPartnerId() == 0) {
            int player1id = player1.getObjectId();
            int player2id = player2.getObjectId();
            Couple couple = new Couple(player1, player2);
            this.getCouples().add(couple);
            player1.setPartnerId(player2id);
            player2.setPartnerId(player1id);
            player1.setCoupleId(couple.getId());
            player2.setCoupleId(couple.getId());
        }
    }

    public void deleteCouple(int coupleId) {
        int index = this.getCoupleIndex(coupleId);
        Couple couple = this.getCouples().get(index);
        if (couple != null) {
            L2PcInstance player1 = L2World.getInstance().getPlayer(couple.getPlayer1Id());
            L2PcInstance player2 = L2World.getInstance().getPlayer(couple.getPlayer2Id());
            if (player1 != null) {
                player1.setPartnerId(0);
                player1.setMarried(false);
                player1.setCoupleId(0);
            }
            if (player2 != null) {
                player2.setPartnerId(0);
                player2.setMarried(false);
                player2.setCoupleId(0);
            }
            couple.divorce();
            this.getCouples().remove(index);
        }
    }

    public int getCoupleIndex(int coupleId) {
        int i = 0;
        for (Couple temp : this.getCouples()) {
            if (temp != null && temp.getId() == coupleId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<Couple> getCouples() {
        return this._couples;
    }

    public static CoupleManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CoupleManager _instance = new CoupleManager();

        private SingletonHolder() {
        }
    }
}

