/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.CombatFlag;
import com.l2jserver.gameserver.model.FortSiegeSpawn;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FortSiegeManager {
    private static final Logger LOG = LoggerFactory.getLogger(FortSiegeManager.class);
    private Map<Integer, List<FortSiegeSpawn>> _commanderSpawnList;
    private Map<Integer, List<CombatFlag>> _flagList;
    private final List<FortSiege> _sieges = new ArrayList<FortSiege>();

    private FortSiegeManager() {
        this.load();
    }

    public void addSiegeSkills(L2PcInstance character) {
        character.addSkill(CommonSkill.SEAL_OF_RULER.getSkill(), false);
        character.addSkill(CommonSkill.BUILD_HEADQUARTERS.getSkill(), false);
    }

    public boolean checkIsRegistered(L2Clan clan, int fortid) {
        if (clan == null) {
            return false;
        }
        boolean register = false;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT clan_id FROM fortsiege_clans where clan_id=? and fort_id=?");){
            ps.setInt(1, clan.getId());
            ps.setInt(2, fortid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    register = true;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception: checkIsRegistered(): {}", (Object)e.getMessage(), (Object)e);
        }
        return register;
    }

    public void removeSiegeSkills(L2PcInstance character) {
        character.removeSkill(CommonSkill.SEAL_OF_RULER.getSkill());
        character.removeSkill(CommonSkill.BUILD_HEADQUARTERS.getSkill());
    }

    private void load() {
        this._commanderSpawnList = new ConcurrentHashMap<Integer, List<FortSiegeSpawn>>();
        this._flagList = new ConcurrentHashMap<Integer, List<CombatFlag>>();
        for (Fort fort : FortManager.getInstance().getForts()) {
            int z;
            int y;
            StringTokenizer st;
            String spawnParams;
            int i;
            ArrayList<FortSiegeSpawn> commanderSpawns = new ArrayList<FortSiegeSpawn>();
            ArrayList<CombatFlag> flagSpawns = new ArrayList<CombatFlag>();
            for (i = 1; i < 5 && (spawnParams = Configuration.fortSiege().getProperty(fort.getName().replace(" ", "") + "Commander" + i)) != null; ++i) {
                st = new StringTokenizer(spawnParams.trim(), ",");
                try {
                    int x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    z = Integer.parseInt(st.nextToken());
                    int heading = Integer.parseInt(st.nextToken());
                    int npc_id = Integer.parseInt(st.nextToken());
                    commanderSpawns.add(new FortSiegeSpawn(fort.getResidenceId(), x, y, z, heading, npc_id, i));
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Error while loading commander(s) for {} fort.", (Object)fort.getName());
                }
            }
            this._commanderSpawnList.put(fort.getResidenceId(), commanderSpawns);
            for (i = 1; i < 4 && (spawnParams = Configuration.fortSiege().getProperty(fort.getName().replace(" ", "") + "Flag" + i)) != null; ++i) {
                st = new StringTokenizer(spawnParams.trim(), ",");
                try {
                    int x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    z = Integer.parseInt(st.nextToken());
                    int flag_id = Integer.parseInt(st.nextToken());
                    flagSpawns.add(new CombatFlag(fort.getResidenceId(), x, y, z, 0, flag_id));
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Error while loading flag(s) for {} fort.", (Object)fort.getName());
                }
            }
            this._flagList.put(fort.getResidenceId(), flagSpawns);
        }
    }

    public List<FortSiegeSpawn> getCommanderSpawnList(int _fortId) {
        return this._commanderSpawnList.get(_fortId);
    }

    public List<CombatFlag> getFlagList(int _fortId) {
        return this._flagList.get(_fortId);
    }

    public FortSiege getSiege(L2Object activeObject) {
        return this.getSiege(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public FortSiege getSiege(int x, int y, int z) {
        for (Fort fort : FortManager.getInstance().getForts()) {
            if (!fort.getSiege().checkIfInZone(x, y, z)) continue;
            return fort.getSiege();
        }
        return null;
    }

    public List<FortSiege> getSieges() {
        return this._sieges;
    }

    public void addSiege(FortSiege fortSiege) {
        this._sieges.add(fortSiege);
    }

    public boolean isCombat(int itemId) {
        return itemId == 9819;
    }

    public boolean activateCombatFlag(L2PcInstance player, L2ItemInstance item) {
        if (!this.checkIfCanPickup(player)) {
            return false;
        }
        Fort fort = FortManager.getInstance().getFort(player);
        List<CombatFlag> fcf = this._flagList.get(fort.getResidenceId());
        for (CombatFlag cf : fcf) {
            if (cf.getCombatFlagInstance() != item) continue;
            cf.activate(player, item);
        }
        return true;
    }

    public boolean checkIfCanPickup(L2PcInstance player) {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED);
        sm.addItemName(9819);
        if (player.isCombatFlagEquipped()) {
            player.sendPacket(sm);
            return false;
        }
        Fort fort = FortManager.getInstance().getFort(player);
        if (fort == null || fort.getResidenceId() <= 0) {
            player.sendPacket(sm);
            return false;
        }
        if (!fort.getSiege().isInProgress()) {
            player.sendPacket(sm);
            return false;
        }
        if (fort.getSiege().getAttackerClan(player.getClan()) == null) {
            player.sendPacket(sm);
            return false;
        }
        return true;
    }

    public void dropCombatFlag(L2PcInstance player, int fortId) {
        Fort fort = FortManager.getInstance().getFortById(fortId);
        List<CombatFlag> fcf = this._flagList.get(fort.getResidenceId());
        for (CombatFlag cf : fcf) {
            if (cf.getPlayerObjectId() != player.getObjectId()) continue;
            cf.dropIt();
            if (!fort.getSiege().isInProgress()) continue;
            cf.spawnMe();
        }
    }

    public static FortSiegeManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FortSiegeManager _instance = new FortSiegeManager();

        private SingletonHolder() {
        }
    }
}

