/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaidBossPointsManager {
    private static final Logger LOG = LoggerFactory.getLogger(RaidBossPointsManager.class);
    private final Map<Integer, Map<Integer, Integer>> _list = new ConcurrentHashMap<Integer, Map<Integer, Integer>>();

    public RaidBossPointsManager() {
        this.init();
    }

    private void init() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT `charId`,`boss_id`,`points` FROM `character_raid_points`");){
            while (rs.next()) {
                int charId = rs.getInt("charId");
                int bossId = rs.getInt("boss_id");
                int points = rs.getInt("points");
                Map<Integer, Integer> values = this._list.get(charId);
                if (values == null) {
                    values = new HashMap<Integer, Integer>();
                }
                values.put(bossId, points);
                this._list.put(charId, values);
            }
            LOG.info("Loaded {} characters raid points.", (Object)this._list.size());
        }
        catch (Exception ex) {
            LOG.warn("Couldn't load character raid points!", ex);
        }
    }

    public final void updatePointsInDB(L2PcInstance player, int raidId, int points) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO character_raid_points (`charId`,`boss_id`,`points`) VALUES (?,?,?)");){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, raidId);
            ps.setInt(3, points);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            LOG.warn("Could not update character raid points for player {}!", (Object)player, (Object)ex);
        }
    }

    public final void addPoints(L2PcInstance player, int bossId, int points) {
        Map tmpPoint = this._list.computeIfAbsent(player.getObjectId(), k -> new HashMap());
        this.updatePointsInDB(player, bossId, tmpPoint.merge(bossId, points, Integer::sum));
    }

    public final int getPointsByOwnerId(int ownerId) {
        Map<Integer, Integer> tmpPoint = this._list.get(ownerId);
        int totalPoints = 0;
        if (tmpPoint == null || tmpPoint.isEmpty()) {
            return 0;
        }
        for (int points : tmpPoint.values()) {
            totalPoints += points;
        }
        return totalPoints;
    }

    public final Map<Integer, Integer> getList(L2PcInstance player) {
        return this._list.get(player.getObjectId());
    }

    public final void cleanUp() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();){
            s.executeUpdate("DELETE from character_raid_points WHERE charId > 0");
            this._list.clear();
        }
        catch (Exception ex) {
            LOG.warn("Could not clean character raid points!", ex);
        }
    }

    public final int calculateRanking(int playerObjId) {
        Map<Integer, Integer> rank = this.getRankList();
        if (rank.containsKey(playerObjId)) {
            return rank.get(playerObjId);
        }
        return 0;
    }

    public Map<Integer, Integer> getRankList() {
        HashMap<Integer, Integer> tmpPoints = new HashMap<Integer, Integer>();
        for (int ownerId : this._list.keySet()) {
            int totalPoints = this.getPointsByOwnerId(ownerId);
            if (totalPoints == 0) continue;
            tmpPoints.put(ownerId, totalPoints);
        }
        ArrayList list = new ArrayList(tmpPoints.entrySet());
        list.sort(Comparator.comparing(Map.Entry::getValue).reversed());
        int ranking = 1;
        HashMap<Integer, Integer> tmpRanking = new HashMap<Integer, Integer>();
        for (Map.Entry entry : list) {
            tmpRanking.put((Integer)entry.getKey(), ranking++);
        }
        return tmpRanking;
    }

    public static RaidBossPointsManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final RaidBossPointsManager _instance = new RaidBossPointsManager();

        private SingletonHolder() {
        }
    }
}

