/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SiegeGuardManager {
    private static final Logger LOG = LoggerFactory.getLogger(SiegeGuardManager.class);
    private final Castle _castle;
    private final List<L2Spawn> _siegeGuardSpawn = new ArrayList<L2Spawn>();

    public SiegeGuardManager(Castle castle) {
        this._castle = castle;
    }

    public void addSiegeGuard(L2PcInstance activeChar, int npcId) {
        if (activeChar == null) {
            return;
        }
        this.addSiegeGuard(activeChar.getX(), activeChar.getY(), activeChar.getZ(), activeChar.getHeading(), npcId);
    }

    private void addSiegeGuard(int x, int y, int z, int heading, int npcId) {
        this.saveSiegeGuard(x, y, z, heading, npcId, 0);
    }

    public void hireMerc(L2PcInstance activeChar, int npcId) {
        if (activeChar == null) {
            return;
        }
        this.hireMerc(activeChar.getX(), activeChar.getY(), activeChar.getZ(), activeChar.getHeading(), npcId);
    }

    public void hireMerc(int x, int y, int z, int heading, int npcId) {
        this.saveSiegeGuard(x, y, z, heading, npcId, 1);
    }

    public void removeMerc(int npcId, int x, int y, int z) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM castle_siege_guards WHERE npcId = ? AND x = ? AND y = ? AND z = ? AND isHired = 1");){
            ps.setInt(1, npcId);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Error deleting hired siege guard at {},{},{}: {}", x, y, z, e.getMessage(), e);
        }
    }

    public void removeMercs() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM castle_siege_guards WHERE castleId = ? AND isHired = 1");){
            ps.setInt(1, this.getCastle().getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Error deleting hired siege guard for castle {}: {}", this.getCastle().getName(), e.getMessage(), e);
        }
    }

    public void spawnSiegeGuard() {
        try {
            int hiredCount = 0;
            int hiredMax = MercTicketManager.getInstance().getMaxAllowedMerc(this._castle.getResidenceId());
            boolean isHired = this.getCastle().getOwnerId() > 0;
            this.loadSiegeGuard();
            for (L2Spawn spawn : this._siegeGuardSpawn) {
                if (spawn == null) continue;
                spawn.init();
                if (!isHired) continue;
                spawn.stopRespawn();
                if (++hiredCount <= hiredMax) continue;
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Error spawning siege guards for castle {}", (Object)this.getCastle().getName(), (Object)e);
        }
    }

    public void unspawnSiegeGuard() {
        for (L2Spawn spawn : this._siegeGuardSpawn) {
            if (spawn == null || spawn.getLastSpawn() == null) continue;
            spawn.stopRespawn();
            spawn.getLastSpawn().doDie(spawn.getLastSpawn());
        }
        this._siegeGuardSpawn.clear();
    }

    private void loadSiegeGuard() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM castle_siege_guards WHERE castleId = ? AND isHired = ?");){
            ps.setInt(1, this.getCastle().getResidenceId());
            if (this.getCastle().getOwnerId() > 0) {
                ps.setInt(2, 1);
            } else {
                ps.setInt(2, 0);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2Spawn spawn = new L2Spawn(rs.getInt("npcId"));
                    spawn.setAmount(1);
                    spawn.setX(rs.getInt("x"));
                    spawn.setY(rs.getInt("y"));
                    spawn.setZ(rs.getInt("z"));
                    spawn.setHeading(rs.getInt("heading"));
                    spawn.setRespawnDelay(rs.getInt("respawnDelay"));
                    spawn.setLocationId(0);
                    this._siegeGuardSpawn.add(spawn);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading siege guard for castle {}: {}", this.getCastle().getName(), e.getMessage(), e);
        }
    }

    private void saveSiegeGuard(int x, int y, int z, int heading, int npcId, int isHire) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("INSERT INTO castle_siege_guards (castleId, npcId, x, y, z, heading, respawnDelay, isHired) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
            ps.setInt(1, this.getCastle().getResidenceId());
            ps.setInt(2, npcId);
            ps.setInt(3, x);
            ps.setInt(4, y);
            ps.setInt(5, z);
            ps.setInt(6, heading);
            ps.setInt(7, isHire == 1 ? 0 : 600);
            ps.setInt(8, isHire);
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Error adding siege guard for castle {}: {}", this.getCastle().getName(), e.getMessage(), e);
        }
    }

    public Castle getCastle() {
        return this._castle;
    }

    public List<L2Spawn> getSiegeGuardSpawn() {
        return this._siegeGuardSpawn;
    }
}

